/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.tttultimate.games;

import net.zomis.tttultimate.TTBase;
import net.zomis.tttultimate.TTPlayer;
import net.zomis.tttultimate.TicUtils;
import net.zomis.tttultimate.games.TTController;

public class TTUltimateController
extends TTController {
    private TTBase activeBoard = null;

    public TTUltimateController(TTBase board) {
        super(board);
    }

    @Override
    public boolean isAllowedPlay(TTBase tile) {
        TTBase area = tile.getParent();
        if (area == null) {
            return false;
        }
        TTBase game = tile.getParent().getParent();
        if (!tile.getWonBy().equals((Object)TTPlayer.NONE)) {
            return false;
        }
        if (area.getWonBy().isExactlyOnePlayer()) {
            return false;
        }
        if (game.isWon()) {
            return false;
        }
        return this.activeBoard == null || this.activeBoard == area || this.activeBoard.getWonBy() != TTPlayer.NONE;
    }

    @Override
    public boolean performPlay(TTBase tile) {
        tile.setPlayedBy(this.currentPlayer);
        this.activeBoard = TicUtils.getDestinationBoard(tile);
        this.nextPlayer();
        do {
            tile.determineWinner();
        } while ((tile = tile.isWon() ? tile.getParent() : null) != null);
        return true;
    }

    @Override
    protected void onReset() {
        this.activeBoard = null;
    }
}

