/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.tttultimate;

public enum TTPlayer {
    NONE,
    X,
    O,
    XO;


    public TTPlayer next() {
        if (!this.isExactlyOnePlayer()) {
            throw new UnsupportedOperationException("Only possible to call .next() on a real player but it was called on " + (Object)((Object)this));
        }
        return this == X ? O : X;
    }

    public boolean is(TTPlayer other) {
        return this.and(other) == other;
    }

    public TTPlayer and(TTPlayer other) {
        if (this == NONE || other == NONE || other == null) {
            return NONE;
        }
        if (this.isExactlyOnePlayer() && other.isExactlyOnePlayer()) {
            return this == other ? this : NONE;
        }
        if (this == XO) {
            return other;
        }
        return other.and(this);
    }

    public boolean isExactlyOnePlayer() {
        return this == X || this == O;
    }

    public static boolean isExactlyOnePlayer(TTPlayer winner) {
        return winner != null && winner.isExactlyOnePlayer();
    }

    public TTPlayer or(TTPlayer other) {
        if (this == NONE || other == null) {
            return other;
        }
        if (other == NONE) {
            return this;
        }
        if (this == XO) {
            return this;
        }
        if (this != other) {
            return XO;
        }
        return this;
    }
}

