/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.tttultimate.games;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.zomis.tttultimate.TTBase;
import net.zomis.tttultimate.TTFactories;
import net.zomis.tttultimate.TTPlayer;
import net.zomis.tttultimate.TTWinCondition;
import net.zomis.tttultimate.TicUtils;
import net.zomis.tttultimate.Winnable;
import net.zomis.tttultimate.games.TTController;

public class TTQuantumController
extends TTController {
    private final Map<TTBase, Integer> subscripts = new HashMap<TTBase, Integer>();
    private TTBase firstPlaced;
    private Integer collapse;
    private int counter;

    public TTQuantumController() {
        super(new TTFactories().ultimate());
        this.onReset();
    }

    @Override
    public boolean isAllowedPlay(TTBase tile) {
        if (this.collapse == null && tile.isWon()) {
            return false;
        }
        if (this.collapse != null) {
            return this.subscripts.get(tile) == this.collapse;
        }
        if (this.firstPlaced != null) {
            return tile.getParent() != this.firstPlaced;
        }
        return !tile.isWon() && !tile.getParent().isWon();
    }

    @Override
    protected boolean performPlay(TTBase tile) {
        if (this.collapse != null) {
            this.collapse = null;
            this.performCollapse(tile);
            this.game.determineWinner();
            if (this.game.getWonBy() == TTPlayer.XO) {
                this.game.setPlayedBy(this.tieBreak());
            }
            return true;
        }
        tile.setPlayedBy(this.currentPlayer);
        this.subscripts.put(tile, this.counter);
        if (this.firstPlaced != null) {
            this.firstPlaced = null;
            this.nextPlayer();
            if (this.isEntaglementCycleCreated(tile)) {
                this.collapse = this.counter;
            }
            ++this.counter;
        } else {
            this.firstPlaced = tile.getParent();
        }
        return true;
    }

    private TTPlayer tieBreak() {
        TTWinCondition lowestWin = null;
        for (TTWinCondition cond : this.game.getWinConds()) {
            TTPlayer pl = cond.determineWinnerNew();
            if (pl == TTPlayer.NONE || lowestWin != null && this.highestSubscript(cond) >= this.highestSubscript(lowestWin)) continue;
            lowestWin = cond;
        }
        return lowestWin.determineWinnerNew();
    }

    private int highestSubscript(TTWinCondition cond) {
        int highest = 0;
        for (Winnable tile : cond) {
            Integer value = this.subscripts.get(tile);
            if (value == null) {
                throw new NullPointerException("Position doesn't have a subscript: " + cond);
            }
            highest = Math.max(highest, value);
        }
        return highest;
    }

    private void performCollapse(TTBase tile) {
        if (!tile.isWon()) {
            throw new IllegalArgumentException("Cannot collapse tile " + tile);
        }
        if (tile.hasSubs()) {
            throw new AssertionError((Object)this.subscripts.toString());
        }
        if (tile.getParent().isWon()) {
            throw new AssertionError();
        }
        TTBase tangled = this.findEntanglement(tile);
        if (tangled != null) {
            this.subscripts.remove(tangled);
            tangled.reset();
        }
        TTPlayer winner = tile.getWonBy();
        Integer value = this.subscripts.remove(tile);
        for (TTBase ff : TicUtils.getAllSubs(tile.getParent())) {
            this.subscripts.remove(ff);
        }
        tile.getParent().reset();
        tile.getParent().setPlayedBy(winner);
        this.subscripts.put(tile.getParent(), value);
        this.collapseCheck();
    }

    private boolean isEntaglementCycleCreated(TTBase tile) {
        return this.isEntaglementCycleCreated(tile, new HashSet<TTBase>(), new HashSet<TTBase>());
    }

    private boolean isEntaglementCycleCreated(TTBase tile, Set<TTBase> scannedAreas, Set<TTBase> scannedTiles) {
        if (tile.getParent() == null || tile.hasSubs()) {
            throw new IllegalArgumentException();
        }
        scannedTiles.add(tile);
        if (scannedAreas.contains(tile.getParent())) {
            return true;
        }
        scannedAreas.add(tile.getParent());
        TTBase area = tile.getParent();
        Collection<TTBase> subs = TicUtils.getAllSubs(area);
        for (TTBase sub : subs) {
            boolean recursive;
            if (sub == tile || !sub.isWon()) continue;
            if (scannedTiles.contains(sub)) {
                return true;
            }
            scannedTiles.add(sub);
            TTBase tangled = this.findEntanglement(sub);
            if (tangled == null || !(recursive = this.isEntaglementCycleCreated(tangled, scannedAreas, scannedTiles))) continue;
            return true;
        }
        return false;
    }

    private void collapseCheck() {
        for (Map.Entry<TTBase, Integer> ee : new HashMap<TTBase, Integer>(this.subscripts).entrySet()) {
            if (ee.getKey().isWon()) continue;
            this.subscripts.remove(ee.getKey());
        }
        for (Map.Entry<TTBase, Integer> ee : this.subscripts.entrySet()) {
            TTBase match;
            if (ee.getKey().hasSubs() || (match = this.findEntanglement(ee.getKey())) != null) continue;
            this.performCollapse(ee.getKey());
            this.collapseCheck();
            return;
        }
    }

    private TTBase findEntanglement(TTBase key) {
        if (!this.subscripts.containsKey(key)) {
            return null;
        }
        int match = this.subscripts.get(key);
        for (Map.Entry<TTBase, Integer> ee : this.subscripts.entrySet()) {
            if (ee.getKey() == key || ee.getValue() != match) continue;
            return ee.getKey();
        }
        return null;
    }

    @Override
    protected void onReset() {
        this.subscripts.clear();
        this.collapse = null;
        this.firstPlaced = null;
        this.counter = 1;
    }

    @Override
    public String getViewFor(TTBase tile) {
        if (!tile.isWon() && tile.getParent().isWon()) {
            tile = tile.getParent();
        }
        Integer sub = this.subscripts.get(tile);
        return super.getViewFor(tile) + (sub != null ? sub : "");
    }
}

