/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.tttultimate.games;

import net.zomis.tttultimate.TTBase;
import net.zomis.tttultimate.TTMoveListener;
import net.zomis.tttultimate.TTPlayer;

public abstract class TTController {
    protected final TTBase game;
    protected TTPlayer currentPlayer = TTPlayer.X;
    private TTMoveListener moveListener;
    private StringBuilder history;

    public TTController(TTBase board) {
        this.game = board;
        this.history = new StringBuilder();
    }

    public abstract boolean isAllowedPlay(TTBase var1);

    public final boolean play(TTBase tile) {
        if (tile == null) {
            throw new IllegalArgumentException("Tile to play at cannot be null.");
        }
        if (!this.isAllowedPlay(tile)) {
            System.out.println("Warning: Move was not made. Unable to play at " + tile);
            return false;
        }
        TTBase playedTile = tile;
        if (!this.performPlay(tile)) {
            return false;
        }
        this.addToHistory(tile);
        if (this.moveListener != null) {
            this.moveListener.onMove(playedTile);
        }
        return true;
    }

    private void addToHistory(TTBase tile) {
        if (this.history.length() > 0) {
            this.history.append(",");
        }
        this.history.append(Integer.toString(tile.getGlobalX(), 36));
        this.history.append(Integer.toString(tile.getGlobalY(), 36));
    }

    protected abstract boolean performPlay(TTBase var1);

    public boolean play(int x, int y) {
        return this.play(this.game.getSmallestTile(x, y));
    }

    public TTPlayer getCurrentPlayer() {
        return this.currentPlayer;
    }

    protected void nextPlayer() {
        this.currentPlayer = this.currentPlayer.next();
    }

    public TTBase getGame() {
        return this.game;
    }

    public boolean isGameOver() {
        return this.game.isWon();
    }

    public TTPlayer getWonBy() {
        return this.game.getWonBy();
    }

    public void setOnMoveListener(TTMoveListener moveListener) {
        this.moveListener = moveListener;
    }

    public void makeMoves(String history) throws IllegalStateException, IllegalArgumentException {
        for (String move : history.split(",")) {
            int y;
            if (move.isEmpty()) continue;
            if (move.length() != 2) {
                throw new IllegalArgumentException("Unexcepted move length. " + move);
            }
            int x = Integer.parseInt(String.valueOf(move.charAt(0)), 36);
            TTBase tile = this.game.getSmallestTile(x, y = Integer.parseInt(String.valueOf(move.charAt(1)), 36));
            if (this.play(tile)) continue;
            throw new IllegalStateException("Unable to make a move at " + x + ", " + y + ": " + tile);
        }
    }

    public String saveHistory() {
        return this.history.toString();
    }

    public void reset() {
        this.currentPlayer = TTPlayer.X;
        this.history = new StringBuilder();
        this.game.reset();
        this.onReset();
    }

    protected abstract void onReset();

    public String getViewFor(TTBase tile) {
        return tile.isWon() ? tile.getWonBy().toString() : "";
    }
}

