/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.tttultimate;

import java.util.Collections;
import java.util.List;
import net.zomis.tttultimate.HasSub;
import net.zomis.tttultimate.TTMNKParameters;
import net.zomis.tttultimate.TTPlayer;
import net.zomis.tttultimate.TTWinCondition;
import net.zomis.tttultimate.TicFactory;
import net.zomis.tttultimate.TicUtils;
import net.zomis.tttultimate.Winnable;

public class TTBase
implements Winnable,
HasSub<TTBase> {
    private final TTBase[][] subs;
    private final TTMNKParameters mnkParams;
    private final List<TTWinCondition> winConditions;
    private final TTBase parent;
    private final int x;
    private final int y;
    private TTPlayer playedBy = TTPlayer.NONE;

    public TTBase(TTBase parent, TTMNKParameters parameters, TicFactory factory) {
        this(parent, 0, 0, parameters, factory);
    }

    public TTBase(TTBase parent, int x, int y, TTMNKParameters parameters, TicFactory factory) {
        this.parent = parent;
        this.mnkParams = parameters;
        this.x = x;
        this.y = y;
        this.subs = new TTBase[parameters.getWidth()][parameters.getHeight()];
        for (int xx = 0; xx < parameters.getWidth(); ++xx) {
            for (int yy = 0; yy < parameters.getHeight(); ++yy) {
                this.subs[xx][yy] = factory.construct(this, xx, yy);
            }
        }
        this.winConditions = Collections.unmodifiableList(TicUtils.setupWins(this));
    }

    public void determineWinner() {
        TTPlayer winner = TTPlayer.NONE;
        for (TTWinCondition cond : this.winConditions) {
            winner = winner.or(cond.determineWinnerNew());
        }
        this.playedBy = winner;
    }

    @Override
    public TTBase getSub(int x, int y) {
        if (!this.hasSubs() && x == 0 && y == 0) {
            return this;
        }
        if (x < 0 || y < 0) {
            return null;
        }
        if (x >= this.getSizeX() || y >= this.getSizeY()) {
            return null;
        }
        return this.subs[x][y];
    }

    public List<TTWinCondition> getWinConds() {
        return this.winConditions;
    }

    @Override
    public TTPlayer getWonBy() {
        return this.playedBy;
    }

    @Override
    public int getSizeX() {
        return this.mnkParams.getWidth();
    }

    @Override
    public int getSizeY() {
        return this.mnkParams.getHeight();
    }

    @Override
    public int getConsecutiveRequired() {
        return this.mnkParams.getConsecutiveRequired();
    }

    public TTMNKParameters getMNKParameters() {
        return this.mnkParams;
    }

    public TTBase getParent() {
        return this.parent;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean isWon() {
        return this.playedBy != TTPlayer.NONE;
    }

    public void setPlayedBy(TTPlayer playedBy) {
        if (playedBy == null && this.hasSubs() && this.parent != null) {
            new Exception().printStackTrace();
        }
        this.playedBy = playedBy;
    }

    @Override
    public boolean hasSubs() {
        return this.getSizeX() != 0 && this.getSizeY() != 0;
    }

    public String toString() {
        return "{Pos " + this.x + ", " + this.y + "; Size " + this.getSizeX() + ", " + this.getSizeY() + "; Played by " + (Object)((Object)this.getWonBy()) + ". Parent is " + this.parent + "}";
    }

    public void reset() {
        this.setPlayedBy(TTPlayer.NONE);
        for (int xx = 0; xx < this.getSizeX(); ++xx) {
            for (int yy = 0; yy < this.getSizeY(); ++yy) {
                this.getSub(xx, yy).reset();
            }
        }
    }

    public int getGlobalX() {
        if (this.parent == null) {
            return 0;
        }
        if (this.parent.getParent() == null) {
            return this.x;
        }
        return this.parent.getX() * this.parent.getParent().getSizeX() + this.x;
    }

    public int getGlobalY() {
        if (this.parent == null) {
            return 0;
        }
        if (this.parent.getParent() == null) {
            return this.y;
        }
        return this.parent.getY() * this.parent.getParent().getSizeY() + this.y;
    }

    public TTBase getSmallestTile(int x, int y) {
        int subY;
        int subX = x / this.getSizeX();
        TTBase board = this.getSub(subX, subY = y / this.getSizeY());
        if (board == null) {
            throw new NullPointerException("No such smallest tile found: " + x + ", " + y);
        }
        return board.getSub(x - subX * this.getSizeX(), y - subY * this.getSizeY());
    }
}

