/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.tttultimate.ais;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.zomis.aiscores.PreScorer;
import net.zomis.tttultimate.TTBase;
import net.zomis.tttultimate.TTPlayer;
import net.zomis.tttultimate.TTWinCondition;
import net.zomis.tttultimate.TicUtils;
import net.zomis.tttultimate.games.TTController;

public class BoardImportanceAnalyze
implements PreScorer<TTController> {
    public Object analyze(TTController params) {
        HashMap importance = new HashMap();
        for (TTBase board : TicUtils.getAllSubs(params.getGame())) {
            HashMap<TTPlayer, Double> map = new HashMap<TTPlayer, Double>();
            for (TTPlayer player : TTPlayer.values()) {
                if (!player.isExactlyOnePlayer()) continue;
                double dd = 0.0;
                for (TTWinCondition win : TicUtils.getWinCondsWith(board, board.getParent())) {
                    if (!win.isWinnable(player)) continue;
                    dd += 0.5 + (double)win.hasCurrently(player);
                }
                map.put(player, dd);
            }
            importance.put(board, map);
        }
        return new BoardImportance(importance);
    }

    public void onScoringComplete() {
    }

    public static class BoardImportance {
        private final Map<TTBase, Map<TTPlayer, Double>> map;

        private BoardImportance(Map<TTBase, Map<TTPlayer, Double>> data) {
            this.map = Collections.unmodifiableMap(data);
        }

        public Map<TTBase, Map<TTPlayer, Double>> getMap() {
            return this.map;
        }

        public double getImportanceFor(TTBase board, TTPlayer player) {
            if (this.map.get(board) == null) {
                return 0.0;
            }
            return this.map.get(board).get((Object)player);
        }
    }
}

