/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.tttultimate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.zomis.tttultimate.HasSub;
import net.zomis.tttultimate.TTBase;
import net.zomis.tttultimate.TTWinCondition;
import net.zomis.tttultimate.Winnable;

public class TicUtils {
    public static TTBase getDestinationBoard(TTBase tile) {
        TTBase parent = tile.getParent();
        if (parent == null) {
            return null;
        }
        TTBase grandpa = parent.getParent();
        if (grandpa == null) {
            return null;
        }
        return grandpa.getSub(tile.getX(), tile.getY());
    }

    public static <E extends Winnable> Collection<TTWinCondition> getWinCondsWith(E field, HasSub<E> board) {
        ArrayList<TTWinCondition> coll = new ArrayList<TTWinCondition>();
        for (TTWinCondition cond : board.getWinConds()) {
            if (!cond.hasWinnable(field)) continue;
            coll.add(cond);
        }
        return coll;
    }

    public static <T> Collection<T> getAllSubs(HasSub<T> board) {
        ArrayList<T> list = new ArrayList<T>();
        int sizeX = board.getSizeX();
        int sizeY = board.getSizeY();
        for (int x = 0; x < sizeX; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                list.add(board.getSub(x, y));
            }
        }
        return list;
    }

    public static Collection<TTBase> getAllSmallestFields(TTBase game) {
        ArrayList<TTBase> all = new ArrayList<TTBase>();
        for (TTBase sub : TicUtils.getAllSubs(game)) {
            if (sub.hasSubs()) {
                all.addAll(TicUtils.getAllSmallestFields(sub));
                continue;
            }
            all.add(sub);
        }
        return all;
    }

    public static List<TTWinCondition> setupWins(HasSub<? extends Winnable> board) {
        int yy;
        int xx;
        if (!board.hasSubs()) {
            ArrayList<TTWinCondition> list = new ArrayList<TTWinCondition>();
            list.add(new TTWinCondition(board));
            return list;
        }
        int consecutive = board.getConsecutiveRequired();
        ArrayList<TTWinCondition> conds = new ArrayList<TTWinCondition>();
        for (xx = 0; xx < board.getSizeX(); ++xx) {
            TicUtils.newWin(conds, consecutive, TicUtils.loopAdd(board, xx, 0, 0, 1));
        }
        for (yy = 0; yy < board.getSizeY(); ++yy) {
            TicUtils.newWin(conds, consecutive, TicUtils.loopAdd(board, 0, yy, 1, 0));
        }
        for (yy = 0; yy < board.getSizeY(); ++yy) {
            TicUtils.newWin(conds, consecutive, TicUtils.loopAdd(board, 0, yy, 1, 1));
        }
        for (xx = 1; xx < board.getSizeX(); ++xx) {
            TicUtils.newWin(conds, consecutive, TicUtils.loopAdd(board, xx, 0, 1, 1));
        }
        for (xx = 0; xx < board.getSizeY(); ++xx) {
            TicUtils.newWin(conds, consecutive, TicUtils.loopAdd(board, xx, 0, -1, 1));
        }
        for (yy = 1; yy < board.getSizeY(); ++yy) {
            TicUtils.newWin(conds, consecutive, TicUtils.loopAdd(board, board.getSizeX() - 1, yy, -1, 1));
        }
        return conds;
    }

    private static void newWin(List<TTWinCondition> conds, int consecutive, List<Winnable> winnables) {
        if (winnables.size() >= consecutive) {
            conds.add(new TTWinCondition(winnables, consecutive));
        }
    }

    private static List<Winnable> loopAdd(HasSub<? extends Winnable> board, int xx, int yy, int dx, int dy) {
        Winnable tile;
        ArrayList<Winnable> winnables = new ArrayList<Winnable>();
        do {
            tile = board.getSub(xx, yy);
            xx += dx;
            yy += dy;
            if (tile == null) continue;
            winnables.add(tile);
        } while (tile != null);
        return winnables;
    }
}

