/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.tttultimate.games;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.zomis.tttultimate.Direction8;
import net.zomis.tttultimate.TTBase;
import net.zomis.tttultimate.TTFactories;
import net.zomis.tttultimate.TTPlayer;
import net.zomis.tttultimate.games.TTController;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\nH\u0014\u00a8\u0006\u0013"}, d2={"Lnet/zomis/tttultimate/games/TTOthello;", "Lnet/zomis/tttultimate/games/TTController;", "size", "", "(I)V", "countSquares", "player", "Lnet/zomis/tttultimate/TTPlayer;", "fieldCover", "", "Lnet/zomis/tttultimate/TTBase;", "tile", "isAllowedPlay", "", "isMovePossible", "currentPlayer", "onReset", "", "performPlay", "uttt-jvm"})
public final class TTOthello
extends TTController {
    @Override
    public boolean isAllowedPlay(@NotNull TTBase tile) {
        Intrinsics.checkParameterIsNotNull((Object)tile, (String)"tile");
        if (this.getGame().isWon()) {
            return false;
        }
        if (tile.hasSubs()) {
            return false;
        }
        return tile.isWon() ? false : !this.fieldCover(tile, this.getCurrentPlayer()).isEmpty();
    }

    private final List<TTBase> fieldCover(TTBase tile, TTPlayer player) {
        if (!player.isExactlyOnePlayer()) {
            throw (Throwable)new IllegalArgumentException();
        }
        boolean bl = false;
        List tt = new ArrayList();
        TTBase parent = tile.getParent();
        for (Direction8 dir : Direction8.values()) {
            boolean matchFound = false;
            boolean bl2 = false;
            List thisDirection = new ArrayList();
            TTBase loop = tile;
            do {
                TTBase tTBase = parent;
                if (tTBase == null) {
                    Intrinsics.throwNpe();
                }
                TTBase tTBase2 = loop;
                if (tTBase2 == null) {
                    Intrinsics.throwNpe();
                }
                if ((loop = tTBase.getSub(tTBase2.getX() + dir.getDeltaX(), loop.getY() + dir.getDeltaY())) == null || loop.getWonBy() == TTPlayer.NONE) break;
                if (player.and(loop.getWonBy()) == player) {
                    matchFound = true;
                }
                if (player == loop.getWonBy()) continue;
                thisDirection.add(loop);
            } while (!matchFound);
            if (!matchFound) continue;
            tt.addAll(thisDirection);
        }
        return tt;
    }

    @Override
    protected boolean performPlay(@NotNull TTBase tile) {
        Intrinsics.checkParameterIsNotNull((Object)tile, (String)"tile");
        List<TTBase> convertingTiles = this.fieldCover(tile, this.getCurrentPlayer());
        for (TTBase ff : convertingTiles) {
            ff.setPlayedBy(this.getCurrentPlayer());
        }
        tile.setPlayedBy(this.getCurrentPlayer());
        this.nextPlayer();
        if (!this.isMovePossible(this.getCurrentPlayer())) {
            this.nextPlayer();
            if (!this.isMovePossible(this.getCurrentPlayer())) {
                int x = this.countSquares(TTPlayer.X);
                int o = this.countSquares(TTPlayer.O);
                TTPlayer result = TTPlayer.NONE;
                if (x >= o) {
                    result = result.or(TTPlayer.X);
                }
                if (o >= x) {
                    result = result.or(TTPlayer.O);
                }
                this.getGame().setPlayedBy(result);
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final int countSquares(TTPlayer player) {
        int count = 0;
        int n = 0;
        int n2 = this.getGame().getSizeX();
        while (n < n2) {
            void xx;
            int n3 = 0;
            int n4 = this.getGame().getSizeY();
            while (n3 < n4) {
                void yy;
                TTBase sub;
                TTBase tTBase = sub = this.getGame().getSub((int)xx, (int)yy);
                if (tTBase == null) {
                    Intrinsics.throwNpe();
                }
                if (tTBase.getWonBy().is(player)) {
                    ++count;
                }
                ++yy;
            }
            ++xx;
        }
        return count;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isMovePossible(TTPlayer currentPlayer) {
        int n = 0;
        int n2 = this.getGame().getSizeX();
        while (n < n2) {
            void xx;
            int n3 = 0;
            int n4 = this.getGame().getSizeY();
            while (n3 < n4) {
                void yy;
                TTBase tTBase = this.getGame().getSub((int)xx, (int)yy);
                if (tTBase == null) {
                    Intrinsics.throwNpe();
                }
                if (this.isAllowedPlay(tTBase)) {
                    return true;
                }
                ++yy;
            }
            ++xx;
        }
        return false;
    }

    @Override
    protected void onReset() {
        TTBase board = this.getGame();
        board.reset();
        int mX = board.getSizeX() / 2;
        int mY = board.getSizeY() / 2;
        TTBase tTBase = board.getSub(mX - 1, mY - 1);
        if (tTBase == null) {
            Intrinsics.throwNpe();
        }
        tTBase.setPlayedBy(TTPlayer.X);
        TTBase tTBase2 = board.getSub(mX - 1, mY);
        if (tTBase2 == null) {
            Intrinsics.throwNpe();
        }
        tTBase2.setPlayedBy(TTPlayer.O);
        TTBase tTBase3 = board.getSub(mX, mY - 1);
        if (tTBase3 == null) {
            Intrinsics.throwNpe();
        }
        tTBase3.setPlayedBy(TTPlayer.O);
        TTBase tTBase4 = board.getSub(mX, mY);
        if (tTBase4 == null) {
            Intrinsics.throwNpe();
        }
        tTBase4.setPlayedBy(TTPlayer.X);
    }

    public TTOthello(int size) {
        super(new TTFactories().othello(size));
        this.onReset();
    }

    public /* synthetic */ TTOthello(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 8;
        }
        this(n);
    }

    public TTOthello() {
        this(0, 1, null);
    }
}

