/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.tttultimate.games;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.CharRange;
import kotlin.text.StringsKt;
import net.zomis.tttultimate.TTBase;
import net.zomis.tttultimate.TTMoveListener;
import net.zomis.tttultimate.TTPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0010\u0010\"\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0003H&J\u000e\u0010#\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020!J\b\u0010$\u001a\u00020\u001eH\u0004J\b\u0010%\u001a\u00020\u001eH$J\u0010\u0010&\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0003H$J\u0016\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)J\u0010\u0010'\u001a\u00020\u00172\b\u0010\u001f\u001a\u0004\u0018\u00010\u0003J\u0006\u0010+\u001a\u00020\u001eJ\u0006\u0010,\u001a\u00020!J\u000e\u0010-\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001aR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000e\u00a8\u0006."}, d2={"Lnet/zomis/tttultimate/games/TTController;", "", "game", "Lnet/zomis/tttultimate/TTBase;", "(Lnet/zomis/tttultimate/TTBase;)V", "CHARS", "", "", "getCHARS", "()Ljava/util/List;", "<set-?>", "Lnet/zomis/tttultimate/TTPlayer;", "currentPlayer", "getCurrentPlayer", "()Lnet/zomis/tttultimate/TTPlayer;", "setCurrentPlayer", "(Lnet/zomis/tttultimate/TTPlayer;)V", "getGame", "()Lnet/zomis/tttultimate/TTBase;", "history", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "isGameOver", "", "()Z", "moveListener", "Lnet/zomis/tttultimate/TTMoveListener;", "wonBy", "getWonBy", "addToHistory", "", "tile", "getViewFor", "", "isAllowedPlay", "makeMoves", "nextPlayer", "onReset", "performPlay", "play", "x", "", "y", "reset", "saveHistory", "setOnMoveListener", "uttt-jvm"})
public abstract class TTController {
    @NotNull
    private TTPlayer currentPlayer;
    private TTMoveListener moveListener;
    private StringBuilder history;
    @NotNull
    private final List<Character> CHARS;
    @NotNull
    private final TTBase game;

    @NotNull
    public final TTPlayer getCurrentPlayer() {
        return this.currentPlayer;
    }

    protected final void setCurrentPlayer(@NotNull TTPlayer tTPlayer) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)tTPlayer), (String)"<set-?>");
        this.currentPlayer = tTPlayer;
    }

    @NotNull
    public final List<Character> getCHARS() {
        return this.CHARS;
    }

    public final boolean isGameOver() {
        return this.game.isWon();
    }

    @NotNull
    public final TTPlayer getWonBy() {
        return this.game.getWonBy();
    }

    public abstract boolean isAllowedPlay(@NotNull TTBase var1);

    public final boolean play(@Nullable TTBase tile) {
        if (tile == null) {
            throw (Throwable)new IllegalArgumentException("Tile to play at cannot be null.");
        }
        if (!this.isAllowedPlay(tile)) {
            return false;
        }
        if (!this.performPlay(tile)) {
            return false;
        }
        this.addToHistory(tile);
        if (this.moveListener != null) {
            TTMoveListener tTMoveListener = this.moveListener;
            if (tTMoveListener == null) {
                Intrinsics.throwNpe();
            }
            tTMoveListener.onMove(tile);
        }
        return true;
    }

    private final void addToHistory(TTBase tile) {
        CharSequence charSequence = this.history;
        boolean bl = false;
        if (!(charSequence.length() == 0)) {
            this.history.append(",");
        }
        this.history.append(this.CHARS.get(tile.getGlobalX()).charValue());
        this.history.append(this.CHARS.get(tile.getGlobalY()).charValue());
    }

    protected abstract boolean performPlay(@NotNull TTBase var1);

    public final boolean play(int x, int y) {
        return this.play(this.game.getSmallestTile(x, y));
    }

    protected final void nextPlayer() {
        this.currentPlayer = this.currentPlayer.next();
    }

    public final void setOnMoveListener(@NotNull TTMoveListener moveListener) {
        Intrinsics.checkParameterIsNotNull((Object)moveListener, (String)"moveListener");
        this.moveListener = moveListener;
    }

    public final void makeMoves(@NotNull String history) {
        Intrinsics.checkParameterIsNotNull((Object)history, (String)"history");
        for (String move : StringsKt.split$default((CharSequence)history, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null)) {
            int y;
            CharSequence charSequence = move;
            boolean bl = false;
            if (charSequence.length() == 0) continue;
            if (move.length() != 2) {
                throw (Throwable)new IllegalArgumentException("Unexcepted move length. " + move);
            }
            int x = this.CHARS.indexOf(Character.valueOf(move.charAt(0)));
            TTBase tile = this.game.getSmallestTile(x, y = this.CHARS.indexOf(Character.valueOf(move.charAt(1))));
            if (this.play(tile)) continue;
            throw (Throwable)new IllegalStateException("Unable to make a move at " + x + ", " + y + ": " + tile);
        }
    }

    @NotNull
    public final String saveHistory() {
        String string = this.history.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.history.toString()");
        return string;
    }

    public final void reset() {
        this.currentPlayer = TTPlayer.X;
        this.history = new StringBuilder();
        this.game.reset();
        this.onReset();
    }

    protected abstract void onReset();

    @NotNull
    public String getViewFor(@NotNull TTBase tile) {
        Intrinsics.checkParameterIsNotNull((Object)tile, (String)"tile");
        return tile.isWon() ? tile.getWonBy().toString() : "";
    }

    @NotNull
    public final TTBase getGame() {
        return this.game;
    }

    public TTController(@NotNull TTBase game) {
        Intrinsics.checkParameterIsNotNull((Object)game, (String)"game");
        this.game = game;
        this.currentPlayer = TTPlayer.X;
        this.history = new StringBuilder();
        char c = '0';
        CharRange charRange = new CharRange(c, '9');
        c = 'a';
        CharRange charRange2 = new CharRange(c, 'z');
        c = 'A';
        this.CHARS = CollectionsKt.plus((Collection)CollectionsKt.plus((Iterable)((Iterable)charRange), (Iterable)((Iterable)charRange2)), (Iterable)((Iterable)new CharRange(c, 'Z')));
    }
}

