/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.tttultimate.games;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.zomis.tttultimate.TTBase;
import net.zomis.tttultimate.TTPlayer;
import net.zomis.tttultimate.TicUtils;
import net.zomis.tttultimate.games.TTController;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0014R(\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0004\u00a8\u0006\u0010"}, d2={"Lnet/zomis/tttultimate/games/TTUltimateController;", "Lnet/zomis/tttultimate/games/TTController;", "board", "Lnet/zomis/tttultimate/TTBase;", "(Lnet/zomis/tttultimate/TTBase;)V", "<set-?>", "activeBoard", "getActiveBoard", "()Lnet/zomis/tttultimate/TTBase;", "setActiveBoard", "isAllowedPlay", "", "tile", "onReset", "", "performPlay", "uttt-jvm"})
public final class TTUltimateController
extends TTController {
    @Nullable
    private TTBase activeBoard;

    @Nullable
    public final TTBase getActiveBoard() {
        return this.activeBoard;
    }

    private final void setActiveBoard(TTBase tTBase) {
        this.activeBoard = tTBase;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isAllowedPlay(@NotNull TTBase tile) {
        Intrinsics.checkParameterIsNotNull((Object)tile, (String)"tile");
        TTBase tTBase = tile.getParent();
        if (tTBase == null) return false;
        TTBase area = tTBase;
        TTBase game = tile.getParent().getParent();
        if (Intrinsics.areEqual((Object)((Object)tile.getWonBy()), (Object)((Object)TTPlayer.NONE)) ^ true) {
            return false;
        }
        if (area.getWonBy().isExactlyOnePlayer()) {
            return false;
        }
        TTBase tTBase2 = game;
        if (tTBase2 == null) {
            Intrinsics.throwNpe();
        }
        if (tTBase2.isWon()) {
            return false;
        }
        if (this.activeBoard == null) return true;
        if (Intrinsics.areEqual((Object)this.activeBoard, (Object)area)) return true;
        TTBase tTBase3 = this.activeBoard;
        if (tTBase3 == null) {
            Intrinsics.throwNpe();
        }
        if (tTBase3.getWonBy() == TTPlayer.NONE) return false;
        return true;
    }

    @Override
    protected boolean performPlay(@NotNull TTBase tile) {
        Intrinsics.checkParameterIsNotNull((Object)tile, (String)"tile");
        tile.setPlayedBy(this.getCurrentPlayer());
        this.activeBoard = TicUtils.INSTANCE.getDestinationBoard(tile);
        this.nextPlayer();
        TTBase playAt = tile;
        do {
            playAt.determineWinner();
        } while ((playAt = playAt.isWon() ? playAt.getParent() : null) != null);
        return true;
    }

    @Override
    protected void onReset() {
        this.activeBoard = null;
    }

    public TTUltimateController(@NotNull TTBase board) {
        Intrinsics.checkParameterIsNotNull((Object)board, (String)"board");
        super(board);
    }
}

