/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.tttultimate.players;

import java.util.Random;
import net.zomis.aiscores.FScorer;
import net.zomis.aiscores.PreScorer;
import net.zomis.aiscores.ScoreConfig;
import net.zomis.aiscores.ScoreConfigFactory;
import net.zomis.aiscores.scorers.Scorers;
import net.zomis.fight.FightInterface;
import net.zomis.tttultimate.TTBase;
import net.zomis.tttultimate.TTFactories;
import net.zomis.tttultimate.TTPlayer;
import net.zomis.tttultimate.ais.BlockOpponentScorer;
import net.zomis.tttultimate.ais.BoardImportanceAnalyze;
import net.zomis.tttultimate.ais.DestinationBoardIsWonScorer;
import net.zomis.tttultimate.ais.INeedScorerV1;
import net.zomis.tttultimate.ais.INeedScorerV2;
import net.zomis.tttultimate.ais.INeedScorerV3;
import net.zomis.tttultimate.ais.INeedScorerV4;
import net.zomis.tttultimate.ais.ImportantForMe;
import net.zomis.tttultimate.ais.OpponentShouldNotPlayScorerV1;
import net.zomis.tttultimate.ais.OpponentShouldNotPlayScorerV2;
import net.zomis.tttultimate.ais.OpponentShouldNotPlayScorerV3;
import net.zomis.tttultimate.ais.WhereCanOpponentSendMe;
import net.zomis.tttultimate.games.TTController;
import net.zomis.tttultimate.games.TTUltimateController;
import net.zomis.tttultimate.players.TTAI;

public class TTAIFactory {
    private final String name;
    private final ScoreConfigFactory<TTController, TTBase> factory;
    private static Random random = new Random();

    private TTAIFactory(String name, ScoreConfigFactory<TTController, TTBase> factory2) {
        this.name = name;
        this.factory = factory2;
    }

    public TTAI build() {
        return new TTAI(this.name, (ScoreConfig<TTController, TTBase>)this.factory.build());
    }

    private ScoreConfigFactory<TTController, TTBase> copy() {
        return this.factory.copy();
    }

    public static TTAIFactory random() {
        return new TTAIFactory("#AI_Complete_Idiot", (ScoreConfigFactory<TTController, TTBase>)new ScoreConfigFactory());
    }

    public static TTAIFactory versionOne() {
        return new TTAIFactory("#AI_First", (ScoreConfigFactory<TTController, TTBase>)TTAIFactory.random().copy().withScorer((FScorer)new INeedScorerV1()));
    }

    public static TTAIFactory version2() {
        return new TTAIFactory("#AI_Second", (ScoreConfigFactory<TTController, TTBase>)TTAIFactory.versionOne().copy().withPreScorer((PreScorer)new PreScorer<TTController>(){

            public void onScoringComplete() {
            }

            public Object analyze(TTController params) {
                return new Object();
            }
        }).withScorer((FScorer)new OpponentShouldNotPlayScorerV1()));
    }

    public static TTAIFactory version3() {
        return new TTAIFactory("#AI_Third", (ScoreConfigFactory<TTController, TTBase>)TTAIFactory.random().copy().withScorer((FScorer)new INeedScorerV2()).withScorer((FScorer)new OpponentShouldNotPlayScorerV2()));
    }

    public static TTAIFactory improved3() {
        return new TTAIFactory("#AI_Medium", (ScoreConfigFactory<TTController, TTBase>)TTAIFactory.versionOne().copy().withPreScorer((PreScorer)new BoardImportanceAnalyze()).withScorer((FScorer)new INeedScorerV3()).withScorer((FScorer)new OpponentShouldNotPlayScorerV3()).withScorer((FScorer)new WhereCanOpponentSendMe()).withScorer((FScorer)new DestinationBoardIsWonScorer()).withScorer((FScorer)new BlockOpponentScorer()));
    }

    public static TTAIFactory unreleased() {
        return new TTAIFactory("#AI_Unreleased", (ScoreConfigFactory<TTController, TTBase>)TTAIFactory.random().copy().withPreScorer((PreScorer)new BoardImportanceAnalyze()).withScorer(Scorers.normalized((FScorer)Scorers.multiplication((FScorer)new ImportantForMe(), (FScorer)new INeedScorerV4()))).withScorer((FScorer)new OpponentShouldNotPlayScorerV3()).withScorer((FScorer)new WhereCanOpponentSendMe()).withScorer((FScorer)new DestinationBoardIsWonScorer(), 0.7).withScorer((FScorer)new BlockOpponentScorer(), 1.3));
    }

    public static TTAIFactory best() {
        return TTAIFactory.unreleased();
    }

    public static TTAIFactory randomAllIn() {
        long seed = random.nextLong();
        Random random = new Random(seed);
        return new TTAIFactory("Random" + seed, (ScoreConfigFactory<TTController, TTBase>)TTAIFactory.random().copy().withPreScorer((PreScorer)new BoardImportanceAnalyze()).withScorer((FScorer)new INeedScorerV1(), TTAIFactory.r(random)).withScorer((FScorer)new INeedScorerV2(), TTAIFactory.r(random)).withScorer((FScorer)new INeedScorerV3(), TTAIFactory.r(random)).withScorer((FScorer)new OpponentShouldNotPlayScorerV1(), TTAIFactory.r(random)).withScorer((FScorer)new OpponentShouldNotPlayScorerV2(), TTAIFactory.r(random)).withScorer((FScorer)new OpponentShouldNotPlayScorerV3(), TTAIFactory.r(random)).withScorer((FScorer)new BlockOpponentScorer(), TTAIFactory.r(random)).withScorer((FScorer)new DestinationBoardIsWonScorer(), TTAIFactory.r(random)).withScorer((FScorer)new WhereCanOpponentSendMe(), TTAIFactory.r(random)));
    }

    private static double r(Random random) {
        return random.nextDouble();
    }

    public static class FightImpl
    implements FightInterface<TTAI> {
        public TTAI determineWinner(TTAI[] players, int fightNumber) {
            TTAI pl;
            TTBase choice;
            TTBase board = new TTFactories().ultimate(3);
            TTUltimateController game = new TTUltimateController(board);
            while (!game.isGameOver() && (choice = (pl = FightImpl.playerFor(players, game.getCurrentPlayer())).play(game)) != null) {
                game.play(choice);
            }
            if (game.getWonBy() == TTPlayer.BLOCKED) {
                return null;
            }
            return FightImpl.playerFor(players, game.getWonBy());
        }

        private static <E> E playerFor(E[] players, TTPlayer player) {
            switch (player) {
                case X: {
                    return players[0];
                }
                case O: {
                    return players[1];
                }
            }
            throw new IllegalStateException("Unexpected player " + (Object)((Object)player));
        }
    }
}

