/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.tttultimate.players;

import java.util.Collection;
import java.util.Map;
import java.util.Random;
import net.zomis.aiscores.FieldScore;
import net.zomis.aiscores.FieldScoreProducer;
import net.zomis.aiscores.FieldScores;
import net.zomis.aiscores.ScoreConfig;
import net.zomis.aiscores.ScoreParameters;
import net.zomis.aiscores.ScoreStrategy;
import net.zomis.aiscores.extra.ParamAndField;
import net.zomis.aiscores.extra.ScoreUtils;
import net.zomis.tttultimate.TTBase;
import net.zomis.tttultimate.TicUtils;
import net.zomis.tttultimate.games.TTController;

public class TTAI
implements ScoreStrategy<TTController, TTBase> {
    private final ScoreConfig<TTController, TTBase> config;
    private FieldScoreProducer<TTController, TTBase> producer;
    private Random random = new Random();
    private final String name;

    public TTAI(String name, ScoreConfig<TTController, TTBase> config) {
        this.name = name;
        this.config = config;
        this.producer = new FieldScoreProducer(this.config, (ScoreStrategy)this);
    }

    public TTBase play(TTController board) {
        ParamAndField ff = ScoreUtils.pickBest(this.producer, (Object)board, (Random)this.random);
        if (ff == null) {
            return null;
        }
        return (TTBase)ff.getField();
    }

    public FieldScores<TTController, TTBase> score(TTController board) {
        this.producer.setDetailed(true);
        FieldScores scores = this.producer.analyzeAndScore((Object)board);
        this.producer.setDetailed(false);
        return scores;
    }

    public FieldScoreProducer<TTController, TTBase> getProducer() {
        return this.producer;
    }

    public Collection<TTBase> getFieldsToScore(TTController params) {
        return TicUtils.INSTANCE.getAllSmallestFields(params.getGame());
    }

    public boolean canScoreField(ScoreParameters<TTController> parameters, TTBase field) {
        return ((TTController)parameters.getParameters()).isAllowedPlay(field);
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void logScores(TTController board) {
        FieldScores<TTController, TTBase> scores = this.score(board);
        for (Map.Entry ee : scores.getScores().entrySet()) {
            System.out.println("Score for " + ee.getKey());
            FieldScore value = (FieldScore)ee.getValue();
            System.out.println("Normalized: " + value.getNormalized());
            System.out.println("Rank: " + value.getRank());
            System.out.println("Details: " + value.getScoreMap());
            System.out.println();
        }
    }

    public ScoreConfig<TTController, TTBase> getConfig() {
        return this.config;
    }
}

