/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.tttultimate.games;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.zomis.tttultimate.TTBase;
import net.zomis.tttultimate.TTFactories;
import net.zomis.tttultimate.TTPlayer;
import net.zomis.tttultimate.TTWinCondition;
import net.zomis.tttultimate.TicUtils;
import net.zomis.tttultimate.games.TTController;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\bH\u0016J0\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\b2\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u00192\u000e\b\u0002\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u0019H\u0002J\b\u0010\u001b\u001a\u00020\fH\u0014J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\bH\u0002J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\bH\u0014J\b\u0010\u001e\u001a\u00020\u001fH\u0002R\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lnet/zomis/tttultimate/games/TTQuantumController;", "Lnet/zomis/tttultimate/games/TTController;", "()V", "collapse", "", "Ljava/lang/Integer;", "counter", "firstPlaced", "Lnet/zomis/tttultimate/TTBase;", "subscripts", "", "collapseCheck", "", "findEntanglement", "key", "getViewFor", "", "tile", "highestSubscript", "cond", "Lnet/zomis/tttultimate/TTWinCondition;", "isAllowedPlay", "", "isEntaglementCycleCreated", "scannedAreas", "", "scannedTiles", "onReset", "performCollapse", "performPlay", "tieBreak", "Lnet/zomis/tttultimate/TTPlayer;", "uttt-jvm"})
public final class TTQuantumController
extends TTController {
    private final Map<TTBase, Integer> subscripts;
    private TTBase firstPlaced;
    private Integer collapse;
    private int counter;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isAllowedPlay(@NotNull TTBase tile) {
        Intrinsics.checkParameterIsNotNull((Object)tile, (String)"tile");
        if (this.collapse == null && tile.isWon()) {
            return false;
        }
        if (this.collapse != null) {
            if (this.subscripts.get(tile) != this.collapse) return false;
            return true;
        }
        if (this.firstPlaced == null) {
            if (tile.isWon()) return false;
            TTBase tTBase = tile.getParent();
            if (tTBase == null) {
                Intrinsics.throwNpe();
            }
            if (tTBase.isWon()) return false;
            return true;
        }
        boolean bl = Intrinsics.areEqual((Object)tile.getParent(), (Object)this.firstPlaced) ^ true;
        return bl;
    }

    @Override
    protected boolean performPlay(@NotNull TTBase tile) {
        Intrinsics.checkParameterIsNotNull((Object)tile, (String)"tile");
        if (this.collapse != null) {
            this.collapse = null;
            this.performCollapse(tile);
            this.getGame().determineWinner();
            if (this.getGame().getWonBy() == TTPlayer.XO) {
                this.getGame().setPlayedBy(this.tieBreak());
            }
            return true;
        }
        tile.setPlayedBy(this.getCurrentPlayer());
        this.subscripts.put(tile, this.counter);
        if (this.firstPlaced != null) {
            this.firstPlaced = null;
            this.nextPlayer();
            if (TTQuantumController.isEntaglementCycleCreated$default(this, tile, null, null, 6, null)) {
                this.collapse = this.counter;
            }
            int n = this.counter;
            this.counter = n + 1;
        } else {
            this.firstPlaced = tile.getParent();
        }
        return true;
    }

    private final TTPlayer tieBreak() {
        TTWinCondition lowestWin = null;
        for (TTWinCondition cond : this.getGame().getWinConds()) {
            TTPlayer pl = cond.determineWinnerNew();
            if (pl == TTPlayer.NONE || lowestWin != null && this.highestSubscript(cond) >= this.highestSubscript(lowestWin)) continue;
            lowestWin = cond;
        }
        TTWinCondition tTWinCondition = lowestWin;
        if (tTWinCondition == null) {
            Intrinsics.throwNpe();
        }
        return tTWinCondition.determineWinnerNew();
    }

    private final int highestSubscript(TTWinCondition cond) {
        int highest = 0;
        for (TTBase tile : cond) {
            Integer n = this.subscripts.get(tile);
            if (n == null) {
                throw (Throwable)new NullPointerException("Position doesn't have a subscript: " + cond);
            }
            int value = n;
            highest = highest >= value ? highest : value;
        }
        return highest;
    }

    private final void performCollapse(TTBase tile) {
        if (!tile.isWon()) {
            throw (Throwable)new IllegalArgumentException("Cannot collapse tile " + tile);
        }
        if (tile.hasSubs()) {
            throw (Throwable)((Object)new AssertionError((Object)this.subscripts.toString()));
        }
        TTBase tTBase = tile.getParent();
        if (tTBase == null) {
            Intrinsics.throwNpe();
        }
        if (tTBase.isWon()) {
            throw (Throwable)((Object)new AssertionError());
        }
        TTBase tangled = this.findEntanglement(tile);
        if (tangled != null) {
            this.subscripts.remove(tangled);
            tangled.reset();
        }
        TTPlayer winner = tile.getWonBy();
        Integer n = this.subscripts.remove(tile);
        if (n == null) {
            Intrinsics.throwNpe();
        }
        int value = ((Number)n).intValue();
        for (TTBase ff : TicUtils.INSTANCE.getAllSubs(tile.getParent())) {
            this.subscripts.remove(ff);
        }
        tile.getParent().reset();
        tile.getParent().setPlayedBy(winner);
        this.subscripts.put(tile.getParent(), value);
        this.collapseCheck();
    }

    private final boolean isEntaglementCycleCreated(TTBase tile, Set<TTBase> scannedAreas, Set<TTBase> scannedTiles) {
        if (tile.getParent() == null || tile.hasSubs()) {
            throw (Throwable)new IllegalArgumentException();
        }
        scannedTiles.add(tile);
        if (scannedAreas.contains(tile.getParent())) {
            return true;
        }
        scannedAreas.add(tile.getParent());
        TTBase area = tile.getParent();
        Collection<TTBase> subs = TicUtils.INSTANCE.getAllSubs(area);
        for (TTBase sub : subs) {
            boolean recursive;
            if (Intrinsics.areEqual((Object)sub, (Object)tile) || !sub.isWon()) continue;
            if (scannedTiles.contains(sub)) {
                return true;
            }
            scannedTiles.add(sub);
            TTBase tangled = this.findEntanglement(sub);
            if (tangled == null || !(recursive = this.isEntaglementCycleCreated(tangled, scannedAreas, scannedTiles))) continue;
            return true;
        }
        return false;
    }

    static /* bridge */ /* synthetic */ boolean isEntaglementCycleCreated$default(TTQuantumController tTQuantumController, TTBase tTBase, Set set, Set set2, int n, Object object) {
        if ((n & 2) != 0) {
            set = new HashSet();
        }
        if ((n & 4) != 0) {
            set2 = new HashSet();
        }
        return tTQuantumController.isEntaglementCycleCreated(tTBase, set, set2);
    }

    private final void collapseCheck() {
        for (Map.Entry<TTBase, Integer> ee : this.subscripts.entrySet()) {
            if (ee.getKey().isWon()) continue;
            this.subscripts.remove(ee.getKey());
        }
        for (Map.Entry<TTBase, Integer> ee : this.subscripts.entrySet()) {
            TTBase match;
            if (ee.getKey().hasSubs() || (match = this.findEntanglement(ee.getKey())) != null) continue;
            this.performCollapse(ee.getKey());
            this.collapseCheck();
            return;
        }
    }

    private final TTBase findEntanglement(TTBase key) {
        if (!this.subscripts.containsKey(key)) {
            return null;
        }
        Integer match = this.subscripts.get(key);
        for (Map.Entry<TTBase, Integer> ee : this.subscripts.entrySet()) {
            if (Intrinsics.areEqual((Object)ee.getKey(), (Object)key)) continue;
            Integer n = match;
            if (n == null || ((Number)ee.getValue()).intValue() != n.intValue()) continue;
            return ee.getKey();
        }
        return null;
    }

    @Override
    protected void onReset() {
        this.subscripts.clear();
        this.collapse = null;
        this.firstPlaced = null;
        this.counter = 1;
    }

    @Override
    @NotNull
    public String getViewFor(@NotNull TTBase tile) {
        Intrinsics.checkParameterIsNotNull((Object)tile, (String)"tile");
        TTBase tileParent = tile;
        if (!tileParent.isWon()) {
            TTBase tTBase = tileParent.getParent();
            if (tTBase == null) {
                Intrinsics.throwNpe();
            }
            if (tTBase.isWon()) {
                tileParent = tileParent.getParent();
            }
        }
        Map<TTBase, Integer> map = this.subscripts;
        Integer sub = map.get(tileParent);
        StringBuilder stringBuilder = new StringBuilder().append(super.getViewFor(tile));
        Object object = sub;
        if (object == null) {
            object = "";
        }
        return stringBuilder.append(object).toString();
    }

    public TTQuantumController() {
        super(TTFactories.ultimate$default(new TTFactories(), 0, 1, null));
        Map map;
        TTQuantumController tTQuantumController = this;
        tTQuantumController.subscripts = map = (Map)new LinkedHashMap();
        this.onReset();
    }
}

