/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.tttultimate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.zomis.tttultimate.TTBase;
import net.zomis.tttultimate.TTWinCondition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\u0005J\u0010\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u0005J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005J6\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J,\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u00182\u0006\u0010\u0019\u001a\u00020\u00112\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0002J\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\u0006\u0010\b\u001a\u00020\u0005\u00a8\u0006\u001c"}, d2={"Lnet/zomis/tttultimate/TicUtils;", "", "()V", "getAllSmallestFields", "", "Lnet/zomis/tttultimate/TTBase;", "game", "getAllSubs", "board", "getDestinationBoard", "tile", "getWinCondsWith", "Lnet/zomis/tttultimate/TTWinCondition;", "field", "loopAdd", "", "xxStart", "", "yyStart", "dx", "dy", "newWin", "", "conds", "", "consecutive", "winnables", "setupWins", "uttt-jvm"})
public final class TicUtils {
    public static final TicUtils INSTANCE;

    @Nullable
    public final TTBase getDestinationBoard(@NotNull TTBase tile) {
        Intrinsics.checkParameterIsNotNull((Object)tile, (String)"tile");
        TTBase tTBase = tile.getParent();
        if (tTBase == null) {
            return null;
        }
        TTBase parent = tTBase;
        TTBase tTBase2 = parent.getParent();
        if (tTBase2 == null) {
            return null;
        }
        TTBase grandpa = tTBase2;
        return grandpa.getSub(tile.getX(), tile.getY());
    }

    @NotNull
    public final Collection<TTWinCondition> getWinCondsWith(@NotNull TTBase field, @NotNull TTBase board) {
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        Intrinsics.checkParameterIsNotNull((Object)board, (String)"board");
        List coll = new ArrayList();
        for (TTWinCondition cond : board.getWinConds()) {
            if (!cond.hasWinnable(field)) continue;
            coll.add(cond);
        }
        return coll;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<TTBase> getAllSubs(@NotNull TTBase board) {
        Intrinsics.checkParameterIsNotNull((Object)board, (String)"board");
        List list = new ArrayList();
        int sizeX = board.getSizeX();
        int sizeY = board.getSizeY();
        int n = 0;
        int n2 = sizeX;
        while (n < n2) {
            void x;
            int n3 = 0;
            int n4 = sizeY;
            while (n3 < n4) {
                void y;
                TTBase tTBase = board.getSub((int)x, (int)y);
                if (tTBase == null) {
                    Intrinsics.throwNpe();
                }
                list.add(tTBase);
                ++y;
            }
            ++x;
        }
        return list;
    }

    @NotNull
    public final Collection<TTBase> getAllSmallestFields(@NotNull TTBase game) {
        Intrinsics.checkParameterIsNotNull((Object)game, (String)"game");
        List all = new ArrayList();
        for (TTBase sub : this.getAllSubs(game)) {
            if (sub.hasSubs()) {
                all.addAll(this.getAllSmallestFields(sub));
                continue;
            }
            all.add(sub);
        }
        return all;
    }

    @NotNull
    public final List<TTWinCondition> setupWins(@NotNull TTBase board) {
        int yy;
        int xx;
        Intrinsics.checkParameterIsNotNull((Object)board, (String)"board");
        if (!board.hasSubs()) {
            List list = new ArrayList();
            list.add(new TTWinCondition(board));
            return list;
        }
        int consecutive = board.getConsecutiveRequired();
        List conds = new ArrayList();
        int n = 0;
        int n2 = board.getSizeX();
        while (n < n2) {
            this.newWin(conds, consecutive, this.loopAdd(board, xx, 0, 0, 1));
            ++xx;
        }
        xx = 0;
        n2 = board.getSizeY();
        while (xx < n2) {
            this.newWin(conds, consecutive, this.loopAdd(board, 0, yy, 1, 0));
            ++yy;
        }
        n2 = board.getSizeY();
        for (yy = 0; yy < n2; ++yy) {
            this.newWin(conds, consecutive, this.loopAdd(board, 0, yy, 1, 1));
        }
        yy = 1;
        n2 = board.getSizeX();
        while (yy < n2) {
            this.newWin(conds, consecutive, this.loopAdd(board, xx, 0, 1, 1));
            ++xx;
        }
        n2 = board.getSizeX();
        for (xx = 0; xx < n2; ++xx) {
            this.newWin(conds, consecutive, this.loopAdd(board, xx, 0, -1, 1));
        }
        xx = 1;
        n2 = board.getSizeY();
        while (xx < n2) {
            this.newWin(conds, consecutive, this.loopAdd(board, board.getSizeX() - 1, yy, -1, 1));
            ++yy;
        }
        return conds;
    }

    private final void newWin(List<TTWinCondition> conds, int consecutive, List<TTBase> winnables) {
        if (winnables.size() >= consecutive) {
            conds.add(new TTWinCondition(winnables, consecutive));
        }
    }

    private final List<TTBase> loopAdd(TTBase board, int xxStart, int yyStart, int dx, int dy) {
        TTBase tile;
        int xx = xxStart;
        int yy = yyStart;
        List winnables = new ArrayList();
        do {
            tile = board.getSub(xx, yy);
            xx += dx;
            yy += dy;
            if (tile == null) continue;
            winnables.add(tile);
        } while (tile != null);
        return winnables;
    }

    private TicUtils() {
    }

    static {
        TicUtils ticUtils;
        INSTANCE = ticUtils = new TicUtils();
    }
}

