/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.tttultimate;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import net.zomis.tttultimate.TTBase;
import net.zomis.tttultimate.TTPlayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\b\u0016\u0012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0004\"\u00020\u0002\u00a2\u0006\u0002\u0010\u0005B\u0015\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001d\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\fJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002J\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\fJ\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015H\u0096\u0002J\u000e\u0010\u0016\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\fJ\u0006\u0010\u0017\u001a\u00020\tR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lnet/zomis/tttultimate/TTWinCondition;", "", "Lnet/zomis/tttultimate/TTBase;", "winnables", "", "([Lnet/zomis/tttultimate/TTBase;)V", "", "(Ljava/util/List;)V", "consecutive", "", "(Ljava/util/List;I)V", "determineWinnerNew", "Lnet/zomis/tttultimate/TTPlayer;", "hasCurrently", "player", "hasWinnable", "", "field", "isWinnable", "byPlayer", "iterator", "", "neededForWin", "size", "uttt-jvm"})
public final class TTWinCondition
implements Iterable<TTBase>,
KMappedMarker {
    private final List<TTBase> winnables;
    private final int consecutive;

    public final int neededForWin(@NotNull TTPlayer player) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)player), (String)"player");
        return this.winnables.size() - this.hasCurrently(player);
    }

    public final boolean isWinnable(@NotNull TTPlayer byPlayer) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)byPlayer), (String)"byPlayer");
        return this.hasCurrently(byPlayer.next()) == 0;
    }

    public final int hasCurrently(@NotNull TTPlayer player) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)player), (String)"player");
        int i = 0;
        for (TTBase winnable : this.winnables) {
            if (!Intrinsics.areEqual((Object)((Object)winnable.getWonBy().and(player)), (Object)((Object)player))) continue;
            ++i;
        }
        return i;
    }

    @NotNull
    public final TTPlayer determineWinnerNew() {
        TTPlayer winner = TTPlayer.NONE;
        int[] consecutivePlayers = new int[((Object[])TTPlayer.values()).length];
        for (TTBase winnable : this.winnables) {
            TTPlayer current = winnable.getWonBy();
            for (TTPlayer pl : TTPlayer.values()) {
                int i = pl.ordinal();
                if (Intrinsics.areEqual((Object)((Object)pl.and(current)), (Object)((Object)pl))) {
                    int n = i;
                    int n2 = consecutivePlayers[n];
                    consecutivePlayers[n] = n2 + 1;
                } else {
                    consecutivePlayers[i] = 0;
                }
                if (consecutivePlayers[i] < this.consecutive) continue;
                winner = winner.or(pl);
            }
        }
        return winner;
    }

    public final boolean hasWinnable(@NotNull TTBase field) {
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        return this.winnables.contains(field);
    }

    public final int size() {
        return this.winnables.size();
    }

    @Override
    @NotNull
    public Iterator<TTBase> iterator() {
        return CollectionsKt.toMutableList((Collection)this.winnables).iterator();
    }

    public TTWinCondition(TTBase ... winnables) {
        Intrinsics.checkParameterIsNotNull((Object)winnables, (String)"winnables");
        this(ArraysKt.toList((Object[])winnables));
    }

    public TTWinCondition(@NotNull List<TTBase> winnables) {
        Intrinsics.checkParameterIsNotNull(winnables, (String)"winnables");
        this(winnables, winnables.size());
    }

    public TTWinCondition(@NotNull List<TTBase> winnables, int consecutive) {
        Intrinsics.checkParameterIsNotNull(winnables, (String)"winnables");
        if (winnables.isEmpty()) {
            throw (Throwable)new IllegalArgumentException("Can't have an empty win condition!");
        }
        this.winnables = CollectionsKt.toMutableList((Collection)winnables);
        this.consecutive = consecutive;
    }
}

