if (typeof kotlin === 'undefined') {
  throw new Error("Error loading module 'uttt-js'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'uttt-js'.");
}
this['uttt-js'] = function (_, Kotlin) {
  'use strict';
  var Enum = Kotlin.kotlin.Enum;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var throwISE = Kotlin.throwISE;
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var emptyList = Kotlin.kotlin.collections.emptyList_287e2$;
  var toList = Kotlin.kotlin.collections.toList_us0mfu$;
  var toString = Kotlin.toString;
  var Unit = Kotlin.kotlin.Unit;
  var NullPointerException = Kotlin.kotlin.NullPointerException;
  var ensureNotNull = Kotlin.ensureNotNull;
  var UnsupportedOperationException_init = Kotlin.kotlin.UnsupportedOperationException_init_pdl1vj$;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var toMutableList = Kotlin.kotlin.collections.toMutableList_4c7yge$;
  var Iterable = Kotlin.kotlin.collections.Iterable;
  var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
  var unboxChar = Kotlin.unboxChar;
  var split = Kotlin.kotlin.text.split_ip8yn$;
  var toBoxedChar = Kotlin.toBoxedChar;
  var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
  var StringBuilder = Kotlin.kotlin.text.StringBuilder;
  var CharRange = Kotlin.kotlin.ranges.CharRange;
  var plus = Kotlin.kotlin.collections.plus_q4559j$;
  var plus_0 = Kotlin.kotlin.collections.plus_mydzjv$;
  var IllegalArgumentException_init_0 = Kotlin.kotlin.IllegalArgumentException_init;
  var equals = Kotlin.equals;
  var AssertionError_init = Kotlin.kotlin.AssertionError_init_pdl1vj$;
  var AssertionError_init_0 = Kotlin.kotlin.AssertionError_init;
  var HashSet_init = Kotlin.kotlin.collections.HashSet_init_287e2$;
  Direction8.prototype = Object.create(Enum.prototype);
  Direction8.prototype.constructor = Direction8;
  TTPlayer.prototype = Object.create(Enum.prototype);
  TTPlayer.prototype.constructor = TTPlayer;
  TTClassicController.prototype = Object.create(TTController.prototype);
  TTClassicController.prototype.constructor = TTClassicController;
  TTClassicControllerWithGravity.prototype = Object.create(TTClassicController.prototype);
  TTClassicControllerWithGravity.prototype.constructor = TTClassicControllerWithGravity;
  TTOthello.prototype = Object.create(TTController.prototype);
  TTOthello.prototype.constructor = TTOthello;
  TTQuantumController.prototype = Object.create(TTController.prototype);
  TTQuantumController.prototype.constructor = TTQuantumController;
  TTUltimateController.prototype = Object.create(TTController.prototype);
  TTUltimateController.prototype.constructor = TTUltimateController;
  function Direction8(name, ordinal, deltaX, deltaY) {
    Enum.call(this);
    this.deltaX = deltaX;
    this.deltaY = deltaY;
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function Direction8_initFields() {
    Direction8_initFields = function () {
    };
    Direction8$W_instance = new Direction8('W', 0, -1, 0);
    Direction8$NW_instance = new Direction8('NW', 1, -1, -1);
    Direction8$N_instance = new Direction8('N', 2, 0, -1);
    Direction8$NE_instance = new Direction8('NE', 3, 1, -1);
    Direction8$E_instance = new Direction8('E', 4, 1, 0);
    Direction8$SE_instance = new Direction8('SE', 5, 1, 1);
    Direction8$S_instance = new Direction8('S', 6, 0, 1);
    Direction8$SW_instance = new Direction8('SW', 7, -1, 1);
  }
  var Direction8$W_instance;
  function Direction8$W_getInstance() {
    Direction8_initFields();
    return Direction8$W_instance;
  }
  var Direction8$NW_instance;
  function Direction8$NW_getInstance() {
    Direction8_initFields();
    return Direction8$NW_instance;
  }
  var Direction8$N_instance;
  function Direction8$N_getInstance() {
    Direction8_initFields();
    return Direction8$N_instance;
  }
  var Direction8$NE_instance;
  function Direction8$NE_getInstance() {
    Direction8_initFields();
    return Direction8$NE_instance;
  }
  var Direction8$E_instance;
  function Direction8$E_getInstance() {
    Direction8_initFields();
    return Direction8$E_instance;
  }
  var Direction8$SE_instance;
  function Direction8$SE_getInstance() {
    Direction8_initFields();
    return Direction8$SE_instance;
  }
  var Direction8$S_instance;
  function Direction8$S_getInstance() {
    Direction8_initFields();
    return Direction8$S_instance;
  }
  var Direction8$SW_instance;
  function Direction8$SW_getInstance() {
    Direction8_initFields();
    return Direction8$SW_instance;
  }
  Direction8.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Direction8',
    interfaces: [Enum]
  };
  function Direction8$values() {
    return [Direction8$W_getInstance(), Direction8$NW_getInstance(), Direction8$N_getInstance(), Direction8$NE_getInstance(), Direction8$E_getInstance(), Direction8$SE_getInstance(), Direction8$S_getInstance(), Direction8$SW_getInstance()];
  }
  Direction8.values = Direction8$values;
  function Direction8$valueOf(name) {
    switch (name) {
      case 'W':
        return Direction8$W_getInstance();
      case 'NW':
        return Direction8$NW_getInstance();
      case 'N':
        return Direction8$N_getInstance();
      case 'NE':
        return Direction8$NE_getInstance();
      case 'E':
        return Direction8$E_getInstance();
      case 'SE':
        return Direction8$SE_getInstance();
      case 'S':
        return Direction8$S_getInstance();
      case 'SW':
        return Direction8$SW_getInstance();
      default:throwISE('No enum constant net.zomis.tttultimate.Direction8.' + name);
    }
  }
  Direction8.valueOf_61zpoe$ = Direction8$valueOf;
  function HasSub() {
  }
  HasSub.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'HasSub',
    interfaces: [Winnable]
  };
  var Array_0 = Array;
  function TTBase(parent, x, y, mnkParameters, factory) {
    this.parent = parent;
    this.x = x;
    this.y = y;
    this.mnkParameters = mnkParameters;
    this.subs_0 = null;
    this.winConds_wtjdri$_0 = null;
    this.wonBy_xeyw5g$_0 = TTPlayer$NONE_getInstance();
    var array = Array_0(this.mnkParameters.width);
    var tmp$;
    tmp$ = array.length - 1 | 0;
    for (var i = 0; i <= tmp$; i++) {
      var array_0 = Array_0(this.mnkParameters.height);
      var tmp$_0;
      tmp$_0 = array_0.length - 1 | 0;
      for (var i_0 = 0; i_0 <= tmp$_0; i_0++) {
        array_0[i_0] = ensureNotNull(factory)(this, i, i_0);
      }
      array[i] = array_0;
    }
    this.subs_0 = array;
    this.winConds_wtjdri$_0 = TicUtils_getInstance().setupWins_pwa93j$(this);
  }
  Object.defineProperty(TTBase.prototype, 'winConds', {
    get: function () {
      return this.winConds_wtjdri$_0;
    }
  });
  Object.defineProperty(TTBase.prototype, 'wonBy', {
    get: function () {
      return this.wonBy_xeyw5g$_0;
    },
    set: function (wonBy) {
      this.wonBy_xeyw5g$_0 = wonBy;
    }
  });
  Object.defineProperty(TTBase.prototype, 'sizeX', {
    get: function () {
      return this.mnkParameters.width;
    }
  });
  Object.defineProperty(TTBase.prototype, 'sizeY', {
    get: function () {
      return this.mnkParameters.height;
    }
  });
  Object.defineProperty(TTBase.prototype, 'consecutiveRequired', {
    get: function () {
      return this.mnkParameters.consecutiveRequired;
    }
  });
  Object.defineProperty(TTBase.prototype, 'isWon', {
    get: function () {
      return this.wonBy !== TTPlayer$NONE_getInstance();
    }
  });
  Object.defineProperty(TTBase.prototype, 'globalX', {
    get: function () {
      if (this.parent == null) {
        return 0;
      }
      return this.parent.parent == null ? this.x : Kotlin.imul(this.parent.x, this.parent.parent.sizeX) + this.x | 0;
    }
  });
  Object.defineProperty(TTBase.prototype, 'globalY', {
    get: function () {
      if (this.parent == null) {
        return 0;
      }
      return this.parent.parent == null ? this.y : Kotlin.imul(this.parent.y, this.parent.parent.sizeY) + this.y | 0;
    }
  });
  var Collection = Kotlin.kotlin.collections.Collection;
  TTBase.prototype.determineWinner = function () {
    var tmp$;
    var winner = TTPlayer$NONE_getInstance();
    tmp$ = this.winConds.iterator();
    while (tmp$.hasNext()) {
      var cond = tmp$.next();
      winner = winner.or_dow8yv$(cond.determineWinnerNew());
    }
    var tmp$_0 = winner === TTPlayer$NONE_getInstance();
    if (tmp$_0) {
      var $receiver = this.subs();
      var all$result;
      all$break: do {
        var tmp$_1;
        if (Kotlin.isType($receiver, Collection) && $receiver.isEmpty()) {
          all$result = true;
          break all$break;
        }
        tmp$_1 = $receiver.iterator();
        while (tmp$_1.hasNext()) {
          var element = tmp$_1.next();
          if (!element.isWon) {
            all$result = false;
            break all$break;
          }
        }
        all$result = true;
      }
       while (false);
      tmp$_0 = all$result;
    }
    if (tmp$_0) {
      winner = TTPlayer$BLOCKED_getInstance();
    }
    this.wonBy = winner;
  };
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  var addAll = Kotlin.kotlin.collections.addAll_ipc267$;
  TTBase.prototype.subs = function () {
    if (!this.hasSubs()) {
      return emptyList();
    }
    var $receiver = this.subs_0;
    var destination = ArrayList_init();
    var tmp$;
    for (tmp$ = 0; tmp$ !== $receiver.length; ++tmp$) {
      var element = $receiver[tmp$];
      var list = toList(element);
      addAll(destination, list);
    }
    return destination;
  };
  TTBase.prototype.getSub_vux9f0$ = function (x, y) {
    if (!this.hasSubs() && x === 0 && y === 0) {
      return this;
    }
    if (x < 0 || y < 0) {
      return null;
    }
    return x >= this.sizeX || y >= this.sizeY ? null : this.subs_0[x][y];
  };
  TTBase.prototype.setPlayedBy_dow8yv$ = function (playedBy) {
    this.wonBy = playedBy;
  };
  TTBase.prototype.hasSubs = function () {
    return this.sizeX !== 0 && this.sizeY !== 0;
  };
  TTBase.prototype.toString = function () {
    return '{Pos ' + this.x + ', ' + this.y + '; Size ' + this.sizeX + ', ' + this.sizeY + '; Played by ' + this.wonBy + '. Parent is ' + toString(this.parent) + '}';
  };
  TTBase.prototype.reset = function () {
    this.setPlayedBy_dow8yv$(TTPlayer$NONE_getInstance());
    var tmp$;
    tmp$ = this.subs().iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      element.reset();
    }
  };
  TTBase.prototype.getSmallestTile_vux9f0$ = function (x, y) {
    var tmp$, tmp$_0;
    tmp$ = this.getSub_vux9f0$(0, 0);
    if (tmp$ == null) {
      return null;
    }
    var topLeft = tmp$;
    var grandParent = topLeft.hasSubs();
    if (!grandParent) {
      return this.getSub_vux9f0$(x, y);
    }
    var subX = x / topLeft.sizeX | 0;
    var subY = y / topLeft.sizeY | 0;
    tmp$_0 = this.getSub_vux9f0$(subX, subY);
    if (tmp$_0 == null) {
      throw new NullPointerException('No such smallest tile found: ' + x + ', ' + y);
    }
    var board = tmp$_0;
    return board.getSub_vux9f0$(x - Kotlin.imul(subX, this.sizeX) | 0, y - Kotlin.imul(subY, this.sizeY) | 0);
  };
  TTBase.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TTBase',
    interfaces: [HasSub, Winnable]
  };
  function TTBase_init(parent, parameters, factory, $this) {
    $this = $this || Object.create(TTBase.prototype);
    TTBase.call($this, parent, 0, 0, parameters, factory);
    return $this;
  }
  function TTFactories() {
    this.mnkEmpty_0 = new TTMNKParameters(0, 0, 0);
    this.lastFactory_0 = TTFactories$lastFactory$lambda(this);
    this.areaFactory_0 = TTFactories$areaFactory$lambda(this);
  }
  function TTFactories$factory$lambda(closure$mnk, closure$next) {
    return function (parent, x, y) {
      return new TTBase(parent, x, y, closure$mnk, closure$next);
    };
  }
  TTFactories.prototype.factory_4s1e6$ = function (mnk, next) {
    return TTFactories$factory$lambda(mnk, next);
  };
  TTFactories.prototype.classicMNK_qt1dr2$ = function (width, height, consecutive) {
    return TTBase_init(null, new TTMNKParameters(width, height, consecutive), this.lastFactory_0);
  };
  TTFactories.prototype.classicMNK_za3lpa$ = function (mnk) {
    return this.classicMNK_qt1dr2$(mnk, mnk, mnk);
  };
  TTFactories.prototype.ultimate_za3lpa$ = function (mnk) {
    if (mnk === void 0)
      mnk = 3;
    return this.ultimateMNK_qt1dr2$(mnk, mnk, mnk);
  };
  TTFactories.prototype.ultimateMNK_qt1dr2$ = function (width, height, consecutive) {
    return TTBase_init(null, new TTMNKParameters(width, height, consecutive), this.areaFactory_0);
  };
  TTFactories.prototype.othello_za3lpa$ = function (size) {
    return TTBase_init(null, new TTMNKParameters(size, size, size + 1 | 0), this.lastFactory_0);
  };
  function TTFactories$lastFactory$lambda(this$TTFactories) {
    return function (parent, x, y) {
      return new TTBase(parent, x, y, this$TTFactories.mnkEmpty_0, null);
    };
  }
  function TTFactories$areaFactory$lambda(this$TTFactories) {
    return function (parent, x, y) {
      return new TTBase(parent, x, y, parent.mnkParameters, this$TTFactories.lastFactory_0);
    };
  }
  TTFactories.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TTFactories',
    interfaces: []
  };
  function TTMNKParameters(width, height, consecutiveRequired) {
    this.width = width;
    this.height = height;
    this.consecutiveRequired = consecutiveRequired;
  }
  TTMNKParameters.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TTMNKParameters',
    interfaces: []
  };
  function TTMoveListener() {
  }
  TTMoveListener.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'TTMoveListener',
    interfaces: []
  };
  function TTPlayer(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function TTPlayer_initFields() {
    TTPlayer_initFields = function () {
    };
    TTPlayer$NONE_instance = new TTPlayer('NONE', 0);
    TTPlayer$X_instance = new TTPlayer('X', 1);
    TTPlayer$O_instance = new TTPlayer('O', 2);
    TTPlayer$XO_instance = new TTPlayer('XO', 3);
    TTPlayer$BLOCKED_instance = new TTPlayer('BLOCKED', 4);
    TTPlayer$Companion_getInstance();
  }
  var TTPlayer$NONE_instance;
  function TTPlayer$NONE_getInstance() {
    TTPlayer_initFields();
    return TTPlayer$NONE_instance;
  }
  var TTPlayer$X_instance;
  function TTPlayer$X_getInstance() {
    TTPlayer_initFields();
    return TTPlayer$X_instance;
  }
  var TTPlayer$O_instance;
  function TTPlayer$O_getInstance() {
    TTPlayer_initFields();
    return TTPlayer$O_instance;
  }
  var TTPlayer$XO_instance;
  function TTPlayer$XO_getInstance() {
    TTPlayer_initFields();
    return TTPlayer$XO_instance;
  }
  var TTPlayer$BLOCKED_instance;
  function TTPlayer$BLOCKED_getInstance() {
    TTPlayer_initFields();
    return TTPlayer$BLOCKED_instance;
  }
  Object.defineProperty(TTPlayer.prototype, 'isExactlyOnePlayer', {
    get: function () {
      return this === TTPlayer$X_getInstance() || this === TTPlayer$O_getInstance();
    }
  });
  TTPlayer.prototype.next = function () {
    if (!this.isExactlyOnePlayer) {
      throw UnsupportedOperationException_init('Only possible to call .next() on a real player but it was called on ' + toString(this));
    }
    return this === TTPlayer$X_getInstance() ? TTPlayer$O_getInstance() : TTPlayer$X_getInstance();
  };
  TTPlayer.prototype.is_dow8yv$ = function (other) {
    return this.and_dow8yv$(other) === other;
  };
  TTPlayer.prototype.and_dow8yv$ = function (other) {
    if (this === TTPlayer$NONE_getInstance() || other === TTPlayer$NONE_getInstance()) {
      return TTPlayer$NONE_getInstance();
    }
    if (this.isExactlyOnePlayer && other.isExactlyOnePlayer) {
      return this === other ? this : TTPlayer$NONE_getInstance();
    }
    if (this === TTPlayer$BLOCKED_getInstance() || other === TTPlayer$BLOCKED_getInstance()) {
      return other;
    }
    return this === TTPlayer$XO_getInstance() ? other : other.and_dow8yv$(this);
  };
  TTPlayer.prototype.or_dow8yv$ = function (other) {
    if (this === TTPlayer$NONE_getInstance()) {
      return other;
    }
    if (other === TTPlayer$NONE_getInstance()) {
      return this;
    }
    if (this === TTPlayer$XO_getInstance()) {
      return this;
    }
    if (this === TTPlayer$BLOCKED_getInstance() || other === TTPlayer$BLOCKED_getInstance()) {
      return TTPlayer$BLOCKED_getInstance();
    }
    return this !== other ? TTPlayer$XO_getInstance() : this;
  };
  function TTPlayer$Companion() {
    TTPlayer$Companion_instance = this;
  }
  TTPlayer$Companion.prototype.isExactlyOnePlayer_1qwls8$ = function (winner) {
    return winner != null && winner.isExactlyOnePlayer;
  };
  TTPlayer$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var TTPlayer$Companion_instance = null;
  function TTPlayer$Companion_getInstance() {
    TTPlayer_initFields();
    if (TTPlayer$Companion_instance === null) {
      new TTPlayer$Companion();
    }
    return TTPlayer$Companion_instance;
  }
  TTPlayer.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TTPlayer',
    interfaces: [Enum]
  };
  function TTPlayer$values() {
    return [TTPlayer$NONE_getInstance(), TTPlayer$X_getInstance(), TTPlayer$O_getInstance(), TTPlayer$XO_getInstance(), TTPlayer$BLOCKED_getInstance()];
  }
  TTPlayer.values = TTPlayer$values;
  function TTPlayer$valueOf(name) {
    switch (name) {
      case 'NONE':
        return TTPlayer$NONE_getInstance();
      case 'X':
        return TTPlayer$X_getInstance();
      case 'O':
        return TTPlayer$O_getInstance();
      case 'XO':
        return TTPlayer$XO_getInstance();
      case 'BLOCKED':
        return TTPlayer$BLOCKED_getInstance();
      default:throwISE('No enum constant net.zomis.tttultimate.TTPlayer.' + name);
    }
  }
  TTPlayer.valueOf_61zpoe$ = TTPlayer$valueOf;
  function TTWinCondition() {
    this.winnables_0 = null;
    this.consecutive_0 = 0;
  }
  TTWinCondition.prototype.neededForWin_dow8yv$ = function (player) {
    return this.winnables_0.size - this.hasCurrently_dow8yv$(player) | 0;
  };
  TTWinCondition.prototype.isWinnable_dow8yv$ = function (byPlayer) {
    return this.hasCurrently_dow8yv$(byPlayer.next()) === 0;
  };
  TTWinCondition.prototype.hasCurrently_dow8yv$ = function (player) {
    var tmp$;
    var i = 0;
    tmp$ = this.winnables_0.iterator();
    while (tmp$.hasNext()) {
      var winnable = tmp$.next();
      if (winnable.wonBy.and_dow8yv$(player) === player) {
        i = i + 1 | 0;
      }
    }
    return i;
  };
  TTWinCondition.prototype.determineWinnerNew = function () {
    var tmp$, tmp$_0, tmp$_1;
    var winner = TTPlayer$NONE_getInstance();
    var consecutivePlayers = new Int32Array(TTPlayer$values().length);
    tmp$ = this.winnables_0.iterator();
    while (tmp$.hasNext()) {
      var winnable = tmp$.next();
      var current = winnable.wonBy;
      tmp$_0 = TTPlayer$values();
      for (tmp$_1 = 0; tmp$_1 !== tmp$_0.length; ++tmp$_1) {
        var pl = tmp$_0[tmp$_1];
        var i = pl.ordinal;
        if (pl.and_dow8yv$(current) === pl) {
          consecutivePlayers[i] = consecutivePlayers[i] + 1 | 0;
        }
         else {
          consecutivePlayers[i] = 0;
        }
        if (consecutivePlayers[i] >= this.consecutive_0) {
          winner = winner.or_dow8yv$(pl);
        }
      }
    }
    return winner;
  };
  TTWinCondition.prototype.hasWinnable_3k4wwe$ = function (field) {
    return this.winnables_0.contains_11rb$(field);
  };
  TTWinCondition.prototype.size = function () {
    return this.winnables_0.size;
  };
  TTWinCondition.prototype.iterator = function () {
    return toMutableList(this.winnables_0).iterator();
  };
  TTWinCondition.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TTWinCondition',
    interfaces: [Iterable]
  };
  function TTWinCondition_init(winnables, $this) {
    $this = $this || Object.create(TTWinCondition.prototype);
    TTWinCondition_init_0(toList(winnables), $this);
    return $this;
  }
  function TTWinCondition_init_0(winnables, $this) {
    $this = $this || Object.create(TTWinCondition.prototype);
    TTWinCondition_init_1(winnables, winnables.size, $this);
    return $this;
  }
  function TTWinCondition_init_1(winnables, consecutive, $this) {
    $this = $this || Object.create(TTWinCondition.prototype);
    TTWinCondition.call($this);
    if (winnables.isEmpty()) {
      throw IllegalArgumentException_init("Can't have an empty win condition!");
    }
    $this.winnables_0 = toMutableList(winnables);
    $this.consecutive_0 = consecutive;
    return $this;
  }
  function TicUtils() {
    TicUtils_instance = this;
  }
  TicUtils.prototype.getDestinationBoard_1xfwev$ = function (tile) {
    var tmp$, tmp$_0;
    tmp$ = tile.parent;
    if (tmp$ == null) {
      return null;
    }
    var parent = tmp$;
    tmp$_0 = parent.parent;
    if (tmp$_0 == null) {
      return null;
    }
    var grandpa = tmp$_0;
    return grandpa.getSub_vux9f0$(tile.x, tile.y);
  };
  TicUtils.prototype.getWinCondsWith_i04zar$ = function (field, board) {
    var tmp$;
    var coll = ArrayList_init();
    tmp$ = board.winConds.iterator();
    while (tmp$.hasNext()) {
      var cond = tmp$.next();
      if (cond.hasWinnable_3k4wwe$(field)) {
        coll.add_11rb$(cond);
      }
    }
    return coll;
  };
  TicUtils.prototype.getAllSubs_kc14xp$ = function (board) {
    var list = ArrayList_init();
    var sizeX = board.sizeX;
    var sizeY = board.sizeY;
    for (var x = 0; x < sizeX; x++) {
      for (var y = 0; y < sizeY; y++) {
        list.add_11rb$(ensureNotNull(board.getSub_vux9f0$(x, y)));
      }
    }
    return list;
  };
  TicUtils.prototype.getAllSmallestFields_1xfwev$ = function (game) {
    var tmp$;
    var all = ArrayList_init();
    tmp$ = this.getAllSubs_kc14xp$(game).iterator();
    while (tmp$.hasNext()) {
      var sub = tmp$.next();
      if (sub.hasSubs()) {
        all.addAll_brywnq$(this.getAllSmallestFields_1xfwev$(sub));
      }
       else {
        all.add_11rb$(sub);
      }
    }
    return all;
  };
  TicUtils.prototype.setupWins_pwa93j$ = function (board) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4;
    if (!board.hasSubs()) {
      var list = ArrayList_init();
      list.add_11rb$(TTWinCondition_init([board]));
      return list;
    }
    var consecutive = board.consecutiveRequired;
    var conds = ArrayList_init();
    tmp$ = board.sizeX;
    for (var xx = 0; xx < tmp$; xx++) {
      this.newWin_0(conds, consecutive, this.loopAdd_0(board, xx, 0, 0, 1));
    }
    tmp$_0 = board.sizeY;
    for (var yy = 0; yy < tmp$_0; yy++) {
      this.newWin_0(conds, consecutive, this.loopAdd_0(board, 0, yy, 1, 0));
    }
    tmp$_1 = board.sizeY;
    for (var yy_0 = 0; yy_0 < tmp$_1; yy_0++) {
      this.newWin_0(conds, consecutive, this.loopAdd_0(board, 0, yy_0, 1, 1));
    }
    tmp$_2 = board.sizeX;
    for (var xx_0 = 1; xx_0 < tmp$_2; xx_0++) {
      this.newWin_0(conds, consecutive, this.loopAdd_0(board, xx_0, 0, 1, 1));
    }
    tmp$_3 = board.sizeX;
    for (var xx_1 = 0; xx_1 < tmp$_3; xx_1++) {
      this.newWin_0(conds, consecutive, this.loopAdd_0(board, xx_1, 0, -1, 1));
    }
    tmp$_4 = board.sizeY;
    for (var yy_1 = 1; yy_1 < tmp$_4; yy_1++) {
      this.newWin_0(conds, consecutive, this.loopAdd_0(board, board.sizeX - 1 | 0, yy_1, -1, 1));
    }
    return conds;
  };
  TicUtils.prototype.newWin_0 = function (conds, consecutive, winnables) {
    if (winnables.size >= consecutive) {
      conds.add_11rb$(TTWinCondition_init_1(winnables, consecutive));
    }
  };
  TicUtils.prototype.loopAdd_0 = function (board, xxStart, yyStart, dx, dy) {
    var xx = xxStart;
    var yy = yyStart;
    var winnables = ArrayList_init();
    var tile;
    do {
      tile = board.getSub_vux9f0$(xx, yy);
      xx = xx + dx | 0;
      yy = yy + dy | 0;
      if (tile != null)
        winnables.add_11rb$(tile);
    }
     while (tile != null);
    return winnables;
  };
  TicUtils.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'TicUtils',
    interfaces: []
  };
  var TicUtils_instance = null;
  function TicUtils_getInstance() {
    if (TicUtils_instance === null) {
      new TicUtils();
    }
    return TicUtils_instance;
  }
  function Winnable() {
  }
  Winnable.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Winnable',
    interfaces: []
  };
  function TTClassicController(board) {
    TTController.call(this, board);
  }
  TTClassicController.prototype.isAllowedPlay_1xfwev$ = function (tile) {
    return tile.parent != null && !tile.hasSubs() && tile.parent.wonBy.equals(TTPlayer$NONE_getInstance()) && tile.wonBy === TTPlayer$NONE_getInstance();
  };
  TTClassicController.prototype.performPlay_1xfwev$ = function (tile) {
    tile.setPlayedBy_dow8yv$(this.currentPlayer);
    ensureNotNull(tile.parent).determineWinner();
    this.nextPlayer();
    return true;
  };
  TTClassicController.prototype.onReset = function () {
  };
  TTClassicController.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TTClassicController',
    interfaces: [TTController]
  };
  function TTClassicControllerWithGravity(board) {
    TTClassicController.call(this, board);
  }
  TTClassicControllerWithGravity.prototype.isAllowedPlay_1xfwev$ = function (tile) {
    var tmp$;
    var sup = TTClassicController.prototype.isAllowedPlay_1xfwev$.call(this, tile);
    if (!sup)
      return false;
    var parent = tile.parent;
    tmp$ = ensureNotNull(parent).getSub_vux9f0$(tile.x, tile.y + 1 | 0);
    if (tmp$ == null) {
      return true;
    }
    var below = tmp$;
    return below.isWon;
  };
  TTClassicControllerWithGravity.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TTClassicControllerWithGravity',
    interfaces: [TTClassicController]
  };
  function TTController(game) {
    this.game = game;
    this.currentPlayer_6twug1$_0 = TTPlayer$X_getInstance();
    this.moveListener_rcbrxy$_0 = null;
    this.history_hxuqv9$_0 = new StringBuilder();
    this.CHARS = plus_0(plus(new CharRange(48, 57), new CharRange(97, 122)), new CharRange(65, 90));
  }
  Object.defineProperty(TTController.prototype, 'currentPlayer', {
    get: function () {
      return this.currentPlayer_6twug1$_0;
    },
    set: function (currentPlayer) {
      this.currentPlayer_6twug1$_0 = currentPlayer;
    }
  });
  Object.defineProperty(TTController.prototype, 'isGameOver', {
    get: function () {
      return this.game.isWon;
    }
  });
  Object.defineProperty(TTController.prototype, 'wonBy', {
    get: function () {
      return this.game.wonBy;
    }
  });
  TTController.prototype.play_b8f54o$ = function (tile) {
    if (tile == null) {
      throw IllegalArgumentException_init('Tile to play at cannot be null.');
    }
    if (!this.isAllowedPlay_1xfwev$(tile)) {
      return false;
    }
    if (!this.performPlay_1xfwev$(tile)) {
      return false;
    }
    this.addToHistory_egycti$_0(tile);
    if (this.moveListener_rcbrxy$_0 != null) {
      ensureNotNull(this.moveListener_rcbrxy$_0).onMove_1xfwev$(tile);
    }
    return true;
  };
  TTController.prototype.addToHistory_egycti$_0 = function (tile) {
    if (!(this.history_hxuqv9$_0.length === 0)) {
      this.history_hxuqv9$_0.append_gw00v9$(',');
    }
    this.history_hxuqv9$_0.append_s8itvh$(unboxChar(this.CHARS.get_za3lpa$(tile.globalX)));
    this.history_hxuqv9$_0.append_s8itvh$(unboxChar(this.CHARS.get_za3lpa$(tile.globalY)));
  };
  TTController.prototype.play_vux9f0$ = function (x, y) {
    return this.play_b8f54o$(this.game.getSmallestTile_vux9f0$(x, y));
  };
  TTController.prototype.nextPlayer = function () {
    this.currentPlayer = this.currentPlayer.next();
  };
  TTController.prototype.setOnMoveListener_g7ne0b$ = function (moveListener) {
    this.moveListener_rcbrxy$_0 = moveListener;
  };
  TTController.prototype.makeMoves_61zpoe$ = function (history) {
    var tmp$;
    tmp$ = split(history, [',']).iterator();
    while (tmp$.hasNext()) {
      var move = tmp$.next();
      if (move.length === 0)
        continue;
      if (move.length !== 2) {
        throw IllegalArgumentException_init('Unexcepted move length. ' + move);
      }
      var x = this.CHARS.indexOf_11rb$(toBoxedChar(move.charCodeAt(0)));
      var y = this.CHARS.indexOf_11rb$(toBoxedChar(move.charCodeAt(1)));
      var tile = this.game.getSmallestTile_vux9f0$(x, y);
      if (!this.play_b8f54o$(tile))
        throw IllegalStateException_init('Unable to make a move at ' + x + ', ' + y + ': ' + toString(tile));
    }
  };
  TTController.prototype.saveHistory = function () {
    return this.history_hxuqv9$_0.toString();
  };
  TTController.prototype.reset = function () {
    this.currentPlayer = TTPlayer$X_getInstance();
    this.history_hxuqv9$_0 = new StringBuilder();
    this.game.reset();
    this.onReset();
  };
  TTController.prototype.getViewFor_1xfwev$ = function (tile) {
    return tile.isWon ? tile.wonBy.toString() : '';
  };
  TTController.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TTController',
    interfaces: []
  };
  function TTControllers() {
    TTControllers_instance = this;
  }
  TTControllers.prototype.connectFour = function () {
    return new TTClassicControllerWithGravity((new TTFactories()).classicMNK_qt1dr2$(7, 6, 4));
  };
  TTControllers.prototype.classicTTT = function () {
    return new TTClassicController((new TTFactories()).classicMNK_za3lpa$(3));
  };
  TTControllers.prototype.ultimateTTT = function () {
    return new TTUltimateController((new TTFactories()).ultimate_za3lpa$());
  };
  TTControllers.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'TTControllers',
    interfaces: []
  };
  var TTControllers_instance = null;
  function TTControllers_getInstance() {
    if (TTControllers_instance === null) {
      new TTControllers();
    }
    return TTControllers_instance;
  }
  function TTOthello(size) {
    if (size === void 0)
      size = 8;
    TTController.call(this, (new TTFactories()).othello_za3lpa$(size));
    this.onReset();
  }
  TTOthello.prototype.isAllowedPlay_1xfwev$ = function (tile) {
    if (this.game.isWon)
      return false;
    if (tile.hasSubs())
      return false;
    return tile.isWon ? false : !this.fieldCover_0(tile, this.currentPlayer).isEmpty();
  };
  TTOthello.prototype.fieldCover_0 = function (tile, player) {
    var tmp$, tmp$_0;
    if (!player.isExactlyOnePlayer)
      throw IllegalArgumentException_init_0();
    var tt = ArrayList_init();
    var parent = tile.parent;
    tmp$ = Direction8$values();
    for (tmp$_0 = 0; tmp$_0 !== tmp$.length; ++tmp$_0) {
      var dir = tmp$[tmp$_0];
      var matchFound = false;
      var thisDirection = ArrayList_init();
      var loop = tile;
      do {
        loop = ensureNotNull(parent).getSub_vux9f0$(ensureNotNull(loop).x + dir.deltaX | 0, loop.y + dir.deltaY | 0);
        if (loop == null)
          break;
        if (loop.wonBy === TTPlayer$NONE_getInstance())
          break;
        if (player.and_dow8yv$(loop.wonBy) === player) {
          matchFound = true;
        }
        if (player !== loop.wonBy) {
          thisDirection.add_11rb$(loop);
        }
      }
       while (!matchFound);
      if (matchFound)
        tt.addAll_brywnq$(thisDirection);
    }
    return tt;
  };
  TTOthello.prototype.performPlay_1xfwev$ = function (tile) {
    var tmp$;
    var convertingTiles = this.fieldCover_0(tile, this.currentPlayer);
    tmp$ = convertingTiles.iterator();
    while (tmp$.hasNext()) {
      var ff = tmp$.next();
      ff.setPlayedBy_dow8yv$(this.currentPlayer);
    }
    tile.setPlayedBy_dow8yv$(this.currentPlayer);
    this.nextPlayer();
    if (!this.isMovePossible_0(this.currentPlayer)) {
      this.nextPlayer();
      if (!this.isMovePossible_0(this.currentPlayer)) {
        var x = this.countSquares_0(TTPlayer$X_getInstance());
        var o = this.countSquares_0(TTPlayer$O_getInstance());
        var result = TTPlayer$NONE_getInstance();
        if (x >= o)
          result = result.or_dow8yv$(TTPlayer$X_getInstance());
        if (o >= x)
          result = result.or_dow8yv$(TTPlayer$O_getInstance());
        this.game.setPlayedBy_dow8yv$(result);
      }
    }
    return true;
  };
  TTOthello.prototype.countSquares_0 = function (player) {
    var tmp$, tmp$_0;
    var count = 0;
    tmp$ = this.game.sizeX;
    for (var xx = 0; xx < tmp$; xx++) {
      tmp$_0 = this.game.sizeY;
      for (var yy = 0; yy < tmp$_0; yy++) {
        var sub = this.game.getSub_vux9f0$(xx, yy);
        if (ensureNotNull(sub).wonBy.is_dow8yv$(player)) {
          count = count + 1 | 0;
        }
      }
    }
    return count;
  };
  TTOthello.prototype.isMovePossible_0 = function (currentPlayer) {
    var tmp$, tmp$_0;
    tmp$ = this.game.sizeX;
    for (var xx = 0; xx < tmp$; xx++) {
      tmp$_0 = this.game.sizeY;
      for (var yy = 0; yy < tmp$_0; yy++) {
        if (this.isAllowedPlay_1xfwev$(ensureNotNull(this.game.getSub_vux9f0$(xx, yy))))
          return true;
      }
    }
    return false;
  };
  TTOthello.prototype.onReset = function () {
    var board = this.game;
    board.reset();
    var mX = board.sizeX / 2 | 0;
    var mY = board.sizeY / 2 | 0;
    ensureNotNull(board.getSub_vux9f0$(mX - 1 | 0, mY - 1 | 0)).setPlayedBy_dow8yv$(TTPlayer$X_getInstance());
    ensureNotNull(board.getSub_vux9f0$(mX - 1 | 0, mY)).setPlayedBy_dow8yv$(TTPlayer$O_getInstance());
    ensureNotNull(board.getSub_vux9f0$(mX, mY - 1 | 0)).setPlayedBy_dow8yv$(TTPlayer$O_getInstance());
    ensureNotNull(board.getSub_vux9f0$(mX, mY)).setPlayedBy_dow8yv$(TTPlayer$X_getInstance());
  };
  TTOthello.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TTOthello',
    interfaces: [TTController]
  };
  var LinkedHashMap_init = Kotlin.kotlin.collections.LinkedHashMap_init_q3lmfv$;
  function TTQuantumController() {
    TTController.call(this, (new TTFactories()).ultimate_za3lpa$());
    this.subscripts_0 = LinkedHashMap_init();
    this.firstPlaced_0 = null;
    this.collapse_0 = null;
    this.counter_0 = 0;
    this.onReset();
  }
  TTQuantumController.prototype.isAllowedPlay_1xfwev$ = function (tile) {
    var tmp$;
    if (this.collapse_0 == null && tile.isWon) {
      return false;
    }
    if (this.collapse_0 != null) {
      return this.subscripts_0.get_11rb$(tile) === this.collapse_0;
    }
    if (this.firstPlaced_0 != null) {
      tmp$ = !equals(tile.parent, this.firstPlaced_0);
    }
     else
      tmp$ = (!tile.isWon && !ensureNotNull(tile.parent).isWon);
    return tmp$;
  };
  TTQuantumController.prototype.performPlay_1xfwev$ = function (tile) {
    if (this.collapse_0 != null) {
      this.collapse_0 = null;
      this.performCollapse_0(tile);
      this.game.determineWinner();
      if (this.game.wonBy === TTPlayer$XO_getInstance()) {
        this.game.setPlayedBy_dow8yv$(this.tieBreak_0());
      }
      return true;
    }
    tile.setPlayedBy_dow8yv$(this.currentPlayer);
    this.subscripts_0.put_xwzc9p$(tile, this.counter_0);
    if (this.firstPlaced_0 != null) {
      this.firstPlaced_0 = null;
      this.nextPlayer();
      if (this.isEntaglementCycleCreated_0(tile)) {
        this.collapse_0 = this.counter_0;
      }
      this.counter_0 = this.counter_0 + 1 | 0;
    }
     else
      this.firstPlaced_0 = tile.parent;
    return true;
  };
  TTQuantumController.prototype.tieBreak_0 = function () {
    var tmp$;
    var lowestWin = null;
    tmp$ = this.game.winConds.iterator();
    while (tmp$.hasNext()) {
      var cond = tmp$.next();
      var pl = cond.determineWinnerNew();
      if (pl === TTPlayer$NONE_getInstance())
        continue;
      if (lowestWin == null || this.highestSubscript_0(cond) < this.highestSubscript_0(lowestWin))
        lowestWin = cond;
    }
    return ensureNotNull(lowestWin).determineWinnerNew();
  };
  var Map = Kotlin.kotlin.collections.Map;
  var throwCCE = Kotlin.throwCCE;
  TTQuantumController.prototype.highestSubscript_0 = function (cond) {
    var tmp$, tmp$_0;
    var highest = 0;
    tmp$ = cond.iterator();
    while (tmp$.hasNext()) {
      var tile = tmp$.next();
      var $receiver = this.subscripts_0;
      var tmp$_1;
      tmp$_0 = (Kotlin.isType(tmp$_1 = $receiver, Map) ? tmp$_1 : throwCCE()).get_11rb$(tile);
      if (tmp$_0 == null) {
        throw new NullPointerException("Position doesn't have a subscript: " + cond);
      }
      var value = tmp$_0;
      highest = highest >= value ? highest : value;
    }
    return highest;
  };
  TTQuantumController.prototype.performCollapse_0 = function (tile) {
    var tmp$;
    if (!tile.isWon)
      throw IllegalArgumentException_init('Cannot collapse tile ' + tile);
    if (tile.hasSubs())
      throw AssertionError_init(this.subscripts_0.toString());
    if (ensureNotNull(tile.parent).isWon)
      throw AssertionError_init_0();
    var tangled = this.findEntanglement_0(tile);
    if (tangled != null) {
      this.subscripts_0.remove_11rb$(tangled);
      tangled.reset();
    }
    var winner = tile.wonBy;
    var value = ensureNotNull(this.subscripts_0.remove_11rb$(tile));
    tmp$ = TicUtils_getInstance().getAllSubs_kc14xp$(tile.parent).iterator();
    while (tmp$.hasNext()) {
      var ff = tmp$.next();
      this.subscripts_0.remove_11rb$(ff);
    }
    tile.parent.reset();
    tile.parent.setPlayedBy_dow8yv$(winner);
    this.subscripts_0.put_xwzc9p$(tile.parent, value);
    this.collapseCheck_0();
  };
  TTQuantumController.prototype.isEntaglementCycleCreated_0 = function (tile, scannedAreas, scannedTiles) {
    if (scannedAreas === void 0)
      scannedAreas = HashSet_init();
    if (scannedTiles === void 0)
      scannedTiles = HashSet_init();
    var tmp$;
    if (tile.parent == null || tile.hasSubs())
      throw IllegalArgumentException_init_0();
    scannedTiles.add_11rb$(tile);
    if (scannedAreas.contains_11rb$(tile.parent)) {
      return true;
    }
    scannedAreas.add_11rb$(tile.parent);
    var area = tile.parent;
    var subs = TicUtils_getInstance().getAllSubs_kc14xp$(area);
    tmp$ = subs.iterator();
    while (tmp$.hasNext()) {
      var sub = tmp$.next();
      if (equals(sub, tile))
        continue;
      if (!sub.isWon)
        continue;
      if (scannedTiles.contains_11rb$(sub))
        return true;
      scannedTiles.add_11rb$(sub);
      var tangled = this.findEntanglement_0(sub);
      if (tangled != null) {
        var recursive = this.isEntaglementCycleCreated_0(tangled, scannedAreas, scannedTiles);
        if (recursive)
          return true;
      }
    }
    return false;
  };
  TTQuantumController.prototype.collapseCheck_0 = function () {
    var tmp$, tmp$_0;
    tmp$ = this.subscripts_0.entries.iterator();
    while (tmp$.hasNext()) {
      var ee = tmp$.next();
      if (!ee.key.isWon) {
        this.subscripts_0.remove_11rb$(ee.key);
      }
    }
    tmp$_0 = this.subscripts_0.entries.iterator();
    while (tmp$_0.hasNext()) {
      var ee_0 = tmp$_0.next();
      if (ee_0.key.hasSubs()) {
        continue;
      }
      var match = this.findEntanglement_0(ee_0.key);
      if (match == null) {
        this.performCollapse_0(ee_0.key);
        this.collapseCheck_0();
        return;
      }
    }
  };
  TTQuantumController.prototype.findEntanglement_0 = function (key) {
    var tmp$;
    if (!this.subscripts_0.containsKey_11rb$(key))
      return null;
    var match = this.subscripts_0.get_11rb$(key);
    tmp$ = this.subscripts_0.entries.iterator();
    while (tmp$.hasNext()) {
      var ee = tmp$.next();
      if (equals(ee.key, key)) {
        continue;
      }
      if (ee.value === match) {
        return ee.key;
      }
    }
    return null;
  };
  TTQuantumController.prototype.onReset = function () {
    this.subscripts_0.clear();
    this.collapse_0 = null;
    this.firstPlaced_0 = null;
    this.counter_0 = 1;
  };
  TTQuantumController.prototype.getViewFor_1xfwev$ = function (tile) {
    var tileParent = tile;
    if (!ensureNotNull(tileParent != null ? tileParent.isWon : null) && ensureNotNull(tileParent.parent).isWon) {
      tileParent = tileParent.parent;
    }
    var $receiver = this.subscripts_0;
    var key = tileParent;
    var tmp$;
    var sub = (Kotlin.isType(tmp$ = $receiver, Map) ? tmp$ : throwCCE()).get_11rb$(key);
    return TTController.prototype.getViewFor_1xfwev$.call(this, tile) + toString(sub != null ? sub : '');
  };
  TTQuantumController.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TTQuantumController',
    interfaces: [TTController]
  };
  function TTUltimateController(board) {
    TTController.call(this, board);
    this.activeBoard_0 = null;
  }
  TTUltimateController.prototype.isAllowedPlay_1xfwev$ = function (tile) {
    var tmp$, tmp$_0;
    tmp$ = tile.parent;
    if (tmp$ == null) {
      return false;
    }
    var area = tmp$;
    var game = tile.parent.parent;
    if (tile.wonBy !== TTPlayer$NONE_getInstance()) {
      return false;
    }
    if (area.wonBy.isExactlyOnePlayer) {
      return false;
    }
    if (ensureNotNull(game).isWon) {
      tmp$_0 = false;
    }
     else {
      tmp$_0 = this.activeBoard_0 == null || equals(this.activeBoard_0, area) || ensureNotNull(this.activeBoard_0).wonBy !== TTPlayer$NONE_getInstance();
    }
    return tmp$_0;
  };
  TTUltimateController.prototype.performPlay_1xfwev$ = function (tile) {
    tile.setPlayedBy_dow8yv$(this.currentPlayer);
    this.activeBoard_0 = TicUtils_getInstance().getDestinationBoard_1xfwev$(tile);
    this.nextPlayer();
    var playAt = tile;
    do {
      playAt != null ? (playAt.determineWinner(), Unit) : null;
      playAt = ensureNotNull(playAt).isWon ? playAt.parent : null;
    }
     while (playAt != null);
    return true;
  };
  TTUltimateController.prototype.onReset = function () {
    this.activeBoard_0 = null;
  };
  TTUltimateController.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TTUltimateController',
    interfaces: [TTController]
  };
  Object.defineProperty(Direction8, 'W', {
    get: Direction8$W_getInstance
  });
  Object.defineProperty(Direction8, 'NW', {
    get: Direction8$NW_getInstance
  });
  Object.defineProperty(Direction8, 'N', {
    get: Direction8$N_getInstance
  });
  Object.defineProperty(Direction8, 'NE', {
    get: Direction8$NE_getInstance
  });
  Object.defineProperty(Direction8, 'E', {
    get: Direction8$E_getInstance
  });
  Object.defineProperty(Direction8, 'SE', {
    get: Direction8$SE_getInstance
  });
  Object.defineProperty(Direction8, 'S', {
    get: Direction8$S_getInstance
  });
  Object.defineProperty(Direction8, 'SW', {
    get: Direction8$SW_getInstance
  });
  var package$net = _.net || (_.net = {});
  var package$zomis = package$net.zomis || (package$net.zomis = {});
  var package$tttultimate = package$zomis.tttultimate || (package$zomis.tttultimate = {});
  package$tttultimate.Direction8 = Direction8;
  package$tttultimate.HasSub = HasSub;
  package$tttultimate.TTBase_init_50vuqe$ = TTBase_init;
  package$tttultimate.TTBase = TTBase;
  package$tttultimate.TTFactories = TTFactories;
  package$tttultimate.TTMNKParameters = TTMNKParameters;
  package$tttultimate.TTMoveListener = TTMoveListener;
  Object.defineProperty(TTPlayer, 'NONE', {
    get: TTPlayer$NONE_getInstance
  });
  Object.defineProperty(TTPlayer, 'X', {
    get: TTPlayer$X_getInstance
  });
  Object.defineProperty(TTPlayer, 'O', {
    get: TTPlayer$O_getInstance
  });
  Object.defineProperty(TTPlayer, 'XO', {
    get: TTPlayer$XO_getInstance
  });
  Object.defineProperty(TTPlayer, 'BLOCKED', {
    get: TTPlayer$BLOCKED_getInstance
  });
  Object.defineProperty(TTPlayer, 'Companion', {
    get: TTPlayer$Companion_getInstance
  });
  package$tttultimate.TTPlayer = TTPlayer;
  package$tttultimate.TTWinCondition_init_kf8la1$ = TTWinCondition_init;
  package$tttultimate.TTWinCondition_init_yw1kl5$ = TTWinCondition_init_0;
  package$tttultimate.TTWinCondition_init_nwa9aj$ = TTWinCondition_init_1;
  package$tttultimate.TTWinCondition = TTWinCondition;
  Object.defineProperty(package$tttultimate, 'TicUtils', {
    get: TicUtils_getInstance
  });
  package$tttultimate.Winnable = Winnable;
  var package$games = package$tttultimate.games || (package$tttultimate.games = {});
  package$games.TTClassicController = TTClassicController;
  package$games.TTClassicControllerWithGravity = TTClassicControllerWithGravity;
  package$games.TTController = TTController;
  Object.defineProperty(package$games, 'TTControllers', {
    get: TTControllers_getInstance
  });
  package$games.TTOthello = TTOthello;
  package$games.TTQuantumController = TTQuantumController;
  package$games.TTUltimateController = TTUltimateController;
  Kotlin.defineModule('uttt-js', _);
  return _;
}(typeof this['uttt-js'] === 'undefined' ? {} : this['uttt-js'], kotlin);
