/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.aiscores;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.zomis.aiscores.FScorer;
import net.zomis.aiscores.PostScorer;
import net.zomis.aiscores.PreScorer;
import net.zomis.aiscores.ScoreConfig;
import net.zomis.aiscores.ScoreSet;

public class ScoreConfigFactory<P, F> {
    private ScoreSet<P, F> scoreSet = new ScoreSet();
    private final List<PostScorer<P, F>> postScorers = new LinkedList<PostScorer<P, F>>();
    private final List<PreScorer<P>> preScorers = new LinkedList<PreScorer<P>>();

    public static <Params, Field> ScoreConfigFactory<Params, Field> newInstance() {
        return new ScoreConfigFactory();
    }

    public ScoreConfigFactory<P, F> withScoreConfig(ScoreConfig<P, F> config) {
        ScoreConfigFactory<P, F> result = this;
        for (PreScorer<P> preScorer : config.getPreScorers()) {
            if (this.preScorers.contains(preScorer)) continue;
            result = this.withPreScorer(preScorer);
        }
        for (PostScorer postScorer : config.getPostScorers()) {
            if (this.postScorers.contains(postScorer)) continue;
            result = this.withPost(postScorer);
        }
        for (Map.Entry entry : config.getScorers().entrySet()) {
            FScorer key = (FScorer)entry.getKey();
            double value = (Double)entry.getValue();
            if (!this.scoreSet.containsKey(key)) {
                result = this.withScorer(key, value);
                continue;
            }
            this.scoreSet.put(key, value + (Double)this.scoreSet.get(key));
        }
        return result;
    }

    public ScoreConfigFactory<P, F> copy() {
        ScoreConfigFactory<P, F> newInstance = new ScoreConfigFactory<P, F>();
        return newInstance.withScoreConfig(this.build());
    }

    public ScoreConfigFactory<P, F> withScorer(FScorer<P, F> scorer) {
        this.scoreSet.put(scorer, 1.0);
        return this;
    }

    public ScoreConfigFactory<P, F> withScorer(FScorer<P, F> scorer, double weight) {
        this.scoreSet.put(scorer, weight);
        return this;
    }

    public ScoreConfigFactory<P, F> multiplyAll(double value) {
        ScoreSet<P, F> oldScoreSet = this.scoreSet;
        this.scoreSet = new ScoreSet();
        for (Map.Entry ee : oldScoreSet.entrySet()) {
            this.scoreSet.put(ee.getKey(), (Double)ee.getValue() * value);
        }
        return this;
    }

    public ScoreConfigFactory<P, F> withPost(PostScorer<P, F> post) {
        this.postScorers.add(post);
        return this;
    }

    public ScoreConfig<P, F> build() {
        return new ScoreConfig<P, F>(this.preScorers, this.postScorers, this.scoreSet);
    }

    public ScoreConfigFactory<P, F> withPreScorer(PreScorer<P> analyzer) {
        this.preScorers.add(analyzer);
        return this;
    }
}

