/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.aiscores;

import java.util.HashMap;
import java.util.Map;
import net.zomis.aiscores.FieldScores;
import net.zomis.aiscores.PreScorer;
import net.zomis.aiscores.ScoreConfig;
import net.zomis.aiscores.ScoreStrategy;

public class FieldScoreProducer<P, F> {
    private final ScoreConfig<P, F> config;
    private boolean detailed;
    private final ScoreStrategy<P, F> scoreStrategy;

    public FieldScoreProducer(ScoreConfig<P, F> config, ScoreStrategy<P, F> strat) {
        this.config = config;
        this.scoreStrategy = strat;
    }

    public FieldScores<P, F> score(P params, Map<Class<?>, Object> analyzes) {
        FieldScores<P, F> scores = new FieldScores<P, F>(params, this.config, this.scoreStrategy);
        scores.setAnalyzes(analyzes);
        scores.setDetailed(this.detailed);
        scores.determineActiveScorers();
        scores.calculateScores();
        scores.rankScores();
        scores.postHandle();
        for (PreScorer<P> prescore : this.config.getPreScorers()) {
            prescore.onScoringComplete();
        }
        return scores;
    }

    public boolean isDetailed() {
        return this.detailed;
    }

    public void setDetailed(boolean detailed) {
        this.detailed = detailed;
    }

    public Map<Class<?>, Object> analyze(P param) {
        HashMap analyze = new HashMap();
        for (PreScorer<P> preScorers : this.config.getPreScorers()) {
            Object data = preScorers.analyze(param);
            if (data == null) continue;
            analyze.put(data.getClass(), data);
        }
        return analyze;
    }

    public ScoreConfig<P, F> getConfig() {
        return this.config;
    }

    public FieldScores<P, F> analyzeAndScore(P params) {
        return this.score(params, this.analyze(params));
    }
}

