/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.aiscores.extra;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.zomis.aiscores.FieldScore;
import net.zomis.aiscores.FieldScoreProducer;
import net.zomis.aiscores.FieldScores;
import net.zomis.aiscores.ScoreTools;
import net.zomis.aiscores.extra.ParamAndField;

public class ScoreUtils {
    public static <A, B> ParamAndField<A, B> pickBest(Map<A, FieldScores<A, B>> scores, Random random) {
        double max = -2.147483648E9;
        List<FieldScore<B>> maxValues = null;
        Object maxParams = null;
        for (Map.Entry<A, FieldScores<A, B>> ee : scores.entrySet()) {
            double score;
            List<FieldScore<B>> rank1 = ee.getValue().getRank(1);
            if (rank1 == null || !((score = rank1.get(0).getScore()) > max)) continue;
            maxValues = rank1;
            max = score;
            maxParams = ee.getKey();
        }
        if (maxValues == null) {
            return null;
        }
        FieldScore chosen = (FieldScore)ScoreTools.getRandom(maxValues, random);
        return new ParamAndField(maxParams, chosen);
    }

    public static <A, B> ParamAndField<A, B> pickBest(FieldScoreProducer<A, B> producer, A params, Random random) {
        FieldScores<A, B> scores = producer.analyzeAndScore(params);
        HashMap<A, FieldScores<A, B>> map = new HashMap<A, FieldScores<A, B>>();
        map.put(params, scores);
        return ScoreUtils.pickBest(map, random);
    }

    private static <Params, Field> Map<Params, FieldScores<Params, Field>> scoreAll(FieldScoreProducer<Params, Field> producer, Params[] params) {
        HashMap<Params, FieldScores<Params, Field>> allScores = new HashMap<Params, FieldScores<Params, Field>>();
        for (Params param : params) {
            Map<Class<?>, Object> analyze = producer.analyze(param);
            allScores.put(param, producer.score(param, analyze));
        }
        return allScores;
    }

    public static <A, B> ParamAndField<A, B> pickBest(FieldScoreProducer<A, B> producer, A[] params, Random random) {
        Map<A, FieldScores<A, B>> scores = ScoreUtils.scoreAll(producer, params);
        double max = -2.147483648E9;
        List<FieldScore<B>> maxValues = null;
        Object maxParams = null;
        for (Map.Entry<A, FieldScores<A, B>> ee : scores.entrySet()) {
            double score;
            List<FieldScore<B>> rank1 = ee.getValue().getRank(1);
            if (rank1 == null || !((score = rank1.get(0).getScore()) > max)) continue;
            maxValues = rank1;
            max = score;
            maxParams = ee.getKey();
        }
        if (maxValues == null) {
            return null;
        }
        FieldScore chosen = (FieldScore)ScoreTools.getRandom(maxValues, random);
        return new ParamAndField(maxParams, chosen);
    }
}

