/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.aiscores;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import net.zomis.aiscores.FScorer;
import net.zomis.aiscores.FieldScore;
import net.zomis.aiscores.PostScorer;
import net.zomis.aiscores.ScoreConfig;
import net.zomis.aiscores.ScoreParameters;
import net.zomis.aiscores.ScoreStrategy;
import net.zomis.aiscores.ScoreTools;

public class FieldScores<P, F>
implements ScoreParameters<P> {
    private final ScoreConfig<P, F> config;
    private final Map<F, FieldScore<F>> scores = new LinkedHashMap<F, FieldScore<F>>();
    private final P params;
    private final ScoreStrategy<P, F> scoreStrategy;
    private Map<FScorer<P, F>, Double> activeScorers;
    private List<List<FieldScore<F>>> rankedScores;
    private Map<Class<?>, Object> analyzes;
    private boolean detailed;

    @Override
    public <E> E getAnalyze(Class<E> clazz) {
        Object value = this.analyzes.get(clazz);
        if (value == null) {
            throw new NullPointerException("Analyze " + clazz + " not found. Did you forget to add a PreScorer using ScoreConfigFactory.withPreScorer?");
        }
        return (E)value;
    }

    @Override
    public Map<Class<?>, Object> getAnalyzes() {
        return new HashMap(this.analyzes);
    }

    FieldScores(P params, ScoreConfig<P, F> config, ScoreStrategy<P, F> strat) {
        this.params = params;
        this.config = config;
        this.scoreStrategy = strat;
    }

    @Override
    public ScoreStrategy<P, F> getScoreStrategy() {
        return this.scoreStrategy;
    }

    void determineActiveScorers() {
        this.activeScorers = new HashMap<FScorer<P, F>, Double>();
        for (FScorer scorer : this.config.getScorers().keySet()) {
            FScorer realScorer = scorer.scoreWith(this);
            if (realScorer == null) continue;
            this.activeScorers.put(realScorer, (Double)this.config.getScorers().get(scorer));
        }
    }

    void calculateScores() {
        if (this.config == null) {
            throw new NullPointerException("Config is null");
        }
        if (this.config.getScorers() == null) {
            throw new NullPointerException("Config does not have any scorers");
        }
        for (F field : this.scoreStrategy.getFieldsToScore(this.params)) {
            if (!this.scoreStrategy.canScoreField(this, field)) continue;
            FieldScore<F> fscore = new FieldScore<F>(field, this.detailed);
            for (Map.Entry<FScorer<P, F>, Double> ee : this.activeScorers.entrySet()) {
                FScorer<P, F> scorer = ee.getKey();
                double computedScore = scorer.getScoreFor(field, this);
                double weight = ee.getValue();
                fscore.addScore(scorer, computedScore, weight);
            }
            this.scores.put(field, fscore);
        }
    }

    void postHandle() {
        for (PostScorer<P, F> post : this.config.getPostScorers()) {
            post.handle(this);
            this.rankScores();
        }
    }

    @Override
    public P getParameters() {
        return this.params;
    }

    public List<List<FieldScore<F>>> getRankedScores() {
        return this.rankedScores;
    }

    public Map<F, FieldScore<F>> getScores() {
        return new HashMap<F, FieldScore<F>>(this.scores);
    }

    public FieldScore<F> getScoreFor(F field) {
        return this.scores.get(field);
    }

    public void rankScores() {
        SortedSet<Map.Entry<F, FieldScore<F>>> sorted = ScoreTools.entriesSortedByValues(this.scores, true);
        this.rankedScores = new LinkedList<List<FieldScore<F>>>();
        if (sorted.isEmpty()) {
            return;
        }
        double minScore = sorted.last().getValue().getScore();
        double maxScore = sorted.first().getValue().getScore();
        double lastScore = maxScore + 1.0;
        int rank = 0;
        LinkedList currentRank = new LinkedList();
        for (Map.Entry entry : sorted) {
            if (lastScore != ((FieldScore)entry.getValue()).getScore()) {
                lastScore = ((FieldScore)entry.getValue()).getScore();
                ++rank;
                currentRank = new LinkedList();
                this.rankedScores.add(currentRank);
            }
            ((FieldScore)entry.getValue()).setRank(rank);
            double normalized = ScoreTools.normalized(((FieldScore)entry.getValue()).getScore(), minScore, maxScore - minScore);
            ((FieldScore)entry.getValue()).setNormalized(normalized);
            currentRank.add(entry.getValue());
        }
    }

    public List<FieldScore<F>> getRank(int rank) {
        if (this.rankedScores.isEmpty()) {
            return null;
        }
        return this.rankedScores.get(rank - 1);
    }

    public int getRankCount() {
        return this.rankedScores.size();
    }

    public ScoreConfig<P, F> getConfig() {
        return this.config;
    }

    void setAnalyzes(Map<Class<?>, Object> analyzes) {
        this.analyzes = new HashMap(analyzes);
    }

    public void setDetailed(boolean detailed) {
        this.detailed = detailed;
    }
}

