/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.aiscores.extra;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedSet;
import net.zomis.aiscores.FScorer;
import net.zomis.aiscores.PostScorer;
import net.zomis.aiscores.PreScorer;
import net.zomis.aiscores.ScoreConfig;
import net.zomis.aiscores.ScoreConfigFactory;
import net.zomis.aiscores.ScoreSet;
import net.zomis.aiscores.ScoreTools;
import net.zomis.aiscores.extra.GeneticInterface;

public class ScoreGenetics<A, B, C> {
    private final GeneticInterface<A, B, C> geneticFace;
    private final Random random;

    public ScoreGenetics(GeneticInterface<A, B, C> fitness, Random random) {
        this.geneticFace = fitness;
        this.random = random != null ? random : new Random();
    }

    public void output(List<C> configs) {
        for (C ai : configs) {
            ScoreConfig<A, B> conf = this.geneticFace.getConfigFor(ai);
            System.out.println(conf);
        }
    }

    public List<C> iterationFight(List<C> ais) {
        int keep = ais.size() / 2;
        Map<C, Double> fitness = this.geneticFace.fitness(ais);
        System.out.println(fitness);
        SortedSet<Map.Entry<C, Double>> results = ScoreTools.entriesSortedByValues(fitness, true);
        ArrayList<Object> qualified = new ArrayList<Object>();
        int i = 0;
        for (Map.Entry entry : results) {
            if (i < keep) {
                qualified.add(entry.getKey());
            }
            ++i;
        }
        for (Object e : new ArrayList(qualified)) {
            qualified.add(this.modify(e));
        }
        return qualified;
    }

    private C modify(C ai) {
        ScoreConfig<A, B> config = this.geneticFace.getConfigFor(ai);
        ScoreSet<A, B> scores = config.getScorers();
        ArrayList scorerList = new ArrayList(scores.keySet());
        FScorer rand = (FScorer)ScoreTools.getRandom(scorerList, this.random);
        ScoreConfigFactory factory = new ScoreConfigFactory();
        for (PreScorer<A> preScorer : config.getPreScorers()) {
            factory.withPreScorer(preScorer);
        }
        for (PostScorer postScorer : config.getPostScorers()) {
            factory.withPost(postScorer);
        }
        for (Map.Entry entry : scores.entrySet()) {
            if (entry.getKey() == rand) {
                factory.withScorer((FScorer)entry.getKey(), (this.random.nextDouble() - 0.5) * 2.0);
                continue;
            }
            factory.withScorer((FScorer)entry.getKey(), (Double)entry.getValue());
        }
        return this.geneticFace.newFromConfig(factory.build());
    }
}

