/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.aiscores;

import java.util.ArrayList;
import java.util.List;
import net.zomis.aiscores.PostScorer;
import net.zomis.aiscores.PreScorer;
import net.zomis.aiscores.ScoreSet;

public class ScoreConfig<P, F> {
    private final ScoreSet<P, F> scorers;
    private final List<PostScorer<P, F>> postScorers;
    private final List<PreScorer<P>> preScorers;

    public ScoreConfig(ScoreConfig<P, F> copy) {
        this(copy.preScorers, copy.postScorers, copy.scorers);
    }

    public ScoreConfig(List<PreScorer<P>> preScorers, List<PostScorer<P, F>> postScorers, ScoreSet<P, F> scorers) {
        this.postScorers = new ArrayList<PostScorer<P, F>>(postScorers);
        this.preScorers = new ArrayList<PreScorer<P>>(preScorers);
        this.scorers = new ScoreSet<P, F>(scorers);
    }

    public List<PostScorer<P, F>> getPostScorers() {
        return this.postScorers;
    }

    public ScoreSet<P, F> getScorers() {
        return this.scorers;
    }

    public List<PreScorer<P>> getPreScorers() {
        return this.preScorers;
    }

    public String toString() {
        return "Scorers:{PreScorer: " + this.preScorers + ", PostScorer: " + this.postScorers + ", Scorers: " + this.scorers + "}";
    }
}

