/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.aiscores;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;

public class ScoreTools {
    private static Random staticRandom = new Random();

    public static double normalized(double value, double min, double range) {
        if (range == 0.0) {
            return 0.0;
        }
        return (value - min) / range;
    }

    public static <K, V extends Comparable<? super V>> SortedSet<Map.Entry<K, V>> entriesSortedByValues(Map<K, V> map, final boolean descending) {
        TreeSet<Map.Entry<K, V>> sortedEntries = new TreeSet<Map.Entry<K, V>>(new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> e1, Map.Entry<K, V> e2) {
                int res = descending ? ((Comparable)e1.getValue()).compareTo(e2.getValue()) : ((Comparable)e2.getValue()).compareTo(e1.getValue());
                return res != 0 ? -res : 1;
            }
        });
        sortedEntries.addAll(map.entrySet());
        return sortedEntries;
    }

    public static <E> E getRandom(List<E> list, Random random) {
        if (list.isEmpty()) {
            return null;
        }
        if (random == null) {
            random = staticRandom;
        }
        return list.get(random.nextInt(list.size()));
    }
}

