/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.aiscores;

import java.util.HashMap;
import java.util.Map;
import net.zomis.aiscores.FScorer;
import net.zomis.aiscores.PostScorer;
import net.zomis.aiscores.Scorer;

public class FieldScore<F>
implements Comparable<FieldScore<F>> {
    private int rank;
    private double score;
    private final F field;
    private final Map<Scorer, Double> specificScorers;
    private double normalized;

    public FieldScore(F field) {
        this(field, false);
    }

    public FieldScore(F field, boolean detailed) {
        this.field = field;
        this.specificScorers = detailed ? new HashMap() : null;
    }

    void addScore(FScorer<?, F> scorer, double score, double weight) {
        double add = score * weight;
        this.saveScore(scorer, add);
    }

    private void saveScore(Scorer scorer, double score) {
        this.score += score;
        if (scorer != null && this.specificScorers != null) {
            this.specificScorers.put(scorer, score);
        }
    }

    void setRank(int rank) {
        this.rank = rank;
    }

    void setNormalized(double normalized) {
        this.normalized = normalized;
    }

    @Override
    public int compareTo(FieldScore<F> other) {
        return Double.compare(this.score, other.score);
    }

    public double getScore() {
        return this.score;
    }

    public F getField() {
        return this.field;
    }

    void giveExtraScore(PostScorer<?, F> scorer, double bonus) {
        this.saveScore(scorer, bonus);
    }

    public int getRank() {
        return this.rank;
    }

    public double getNormalized() {
        return this.normalized;
    }

    public Map<Scorer, Double> getScoreMap() {
        return this.specificScorers == null ? null : new HashMap<Scorer, Double>(this.specificScorers);
    }

    public String toString() {
        return "(" + this.field + " score " + this.score + ")";
    }
}

