/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.analyze.detail;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.zomis.minesweeper.analyze.AnalyzeResult;
import net.zomis.minesweeper.analyze.detail.DetailedResults;
import net.zomis.minesweeper.analyze.detail.FieldProxy;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;

public class DetailedResultsImpl<T>
implements DetailedResults<T> {
    private final AnalyzeResult<T> analyze;
    private final Map<T, ProbabilityKnowledge<T>> proxies;
    private final int proxyCount;

    public DetailedResultsImpl(AnalyzeResult<T> analyze, Map<T, FieldProxy<T>> proxies, int proxyCount) {
        this.analyze = analyze;
        this.proxies = Collections.unmodifiableMap(new HashMap<T, FieldProxy<T>>(proxies));
        this.proxyCount = proxyCount;
    }

    @Override
    public Collection<ProbabilityKnowledge<T>> getProxies() {
        return Collections.unmodifiableCollection(this.proxies.values());
    }

    @Override
    public int getProxyCount() {
        return this.proxyCount;
    }

    @Override
    public ProbabilityKnowledge<T> getProxyFor(T field) {
        return this.proxies.get(field);
    }

    @Override
    public AnalyzeResult<T> getAnalyze() {
        return this.analyze;
    }

    @Override
    public Map<T, ProbabilityKnowledge<T>> getProxyMap() {
        return Collections.unmodifiableMap(this.proxies);
    }
}

