/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.analyze;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.zomis.minesweeper.analyze.AnalyzeFactory;
import net.zomis.minesweeper.analyze.FieldGroup;
import net.zomis.minesweeper.analyze.GroupValues;
import net.zomis.minesweeper.analyze.RuleConstraint;
import net.zomis.minesweeper.analyze.RuntimeTimeoutException;
import net.zomis.minesweeper.analyze.SimplifyResult;
import net.zomis.minesweeper.analyze.Solution;
import net.zomis.minesweeper.analyze.listener.Analyze;
import net.zomis.minesweeper.analyze.listener.RuleListener;
import net.zomis.minesweeper.analyze.listener.SolveListener;

public class GameAnalyze<T>
implements Analyze<T> {
    private final GroupValues<T> knownValues;
    private final List<RuleConstraint<T>> rules;
    private final int depth;
    private final SolveListener<T> listener;

    GameAnalyze(GroupValues<T> knownValues, List<RuleConstraint<T>> unsolvedRules, int depth, SolveListener<T> listener) {
        this.knownValues = knownValues == null ? new GroupValues() : new GroupValues<T>(knownValues);
        this.rules = unsolvedRules;
        this.depth = depth;
        this.listener = listener;
    }

    private void removeEmptyRules() {
        Iterator<RuleConstraint<T>> it = this.rules.iterator();
        while (it.hasNext()) {
            if (!it.next().isEmpty()) continue;
            it.remove();
        }
    }

    private boolean simplifyRules() {
        boolean simplifyPerformed = true;
        final ArrayList addedRules = new ArrayList();
        final Analyze analyze = new Analyze<T>(){

            @Override
            public int getDepth() {
                return GameAnalyze.this.getDepth();
            }

            @Override
            public void addRule(RuleConstraint<T> rule) {
                addedRules.add(rule);
            }

            @Override
            public GroupValues<T> getKnownValues() {
                return GameAnalyze.this.getKnownValues();
            }
        };
        RuleListener ruleListener = new RuleListener<T>(){

            @Override
            public void onValueSet(FieldGroup<T> group, int value) {
                GameAnalyze.this.listener.onValueSet(analyze, group, value);
            }
        };
        while (simplifyPerformed) {
            simplifyPerformed = false;
            Iterator<RuleConstraint<T>> it = this.rules.iterator();
            while (it.hasNext()) {
                RuleConstraint<T> ruleSimplify = it.next();
                SimplifyResult simplifyResult = ruleSimplify.simplify(this.knownValues, ruleListener);
                if (simplifyResult == SimplifyResult.SIMPLIFIED) {
                    simplifyPerformed = true;
                } else if (simplifyResult.isFailure()) {
                    return false;
                }
                if (!ruleSimplify.isEmpty()) continue;
                it.remove();
            }
            if (addedRules.isEmpty()) continue;
            this.rules.addAll(addedRules);
            AnalyzeFactory.splitFieldRules(this.rules);
            addedRules.clear();
            simplifyPerformed = true;
        }
        return true;
    }

    double solve(List<Solution<T>> solutions) {
        if (!this.simplifyRules()) {
            return 0.0;
        }
        this.removeEmptyRules();
        double total = this.solveRules(solutions);
        if (this.rules.isEmpty()) {
            Solution<T> solved = Solution.createSolution(this.knownValues);
            solutions.add(solved);
            total += solved.nCr();
        }
        return total;
    }

    private double solveRules(List<Solution<T>> solutions) {
        if (Thread.interrupted()) {
            throw new RuntimeTimeoutException();
        }
        if (this.rules.isEmpty()) {
            return 0.0;
        }
        FieldGroup<T> chosenGroup = this.getSmallestFieldGroup();
        if (chosenGroup == null) {
            throw new IllegalStateException("Chosen group is null: " + this.rules);
        }
        int groupSize = chosenGroup.size();
        if (groupSize == 0) {
            throw new IllegalStateException("Chosen group is empty. " + chosenGroup);
        }
        double total = 0.0;
        for (int i = 0; i <= groupSize; ++i) {
            GroupValues<T> mapCopy = new GroupValues<T>(this.knownValues);
            mapCopy.put(chosenGroup, i);
            ArrayList<RuleConstraint<T>> rulesCopy = new ArrayList<RuleConstraint<T>>();
            for (RuleConstraint<T> rule : this.rules) {
                rulesCopy.add(rule.copy());
            }
            GameAnalyze<T> copy = new GameAnalyze<T>(mapCopy, rulesCopy, this.depth + 1, this.listener);
            int rulesCountBefore = copy.rules.size();
            this.listener.onValueSet(copy, chosenGroup, i);
            int rulesCountAfter = copy.rules.size();
            if (rulesCountBefore != rulesCountAfter) {
                AnalyzeFactory.splitFieldRules(copy.rules);
            }
            total += copy.solve(solutions);
        }
        return total;
    }

    private FieldGroup<T> getSmallestFieldGroup() {
        for (RuleConstraint<T> rule : this.rules) {
            FieldGroup<T> smallest = rule.getSmallestFieldGroup();
            if (smallest == null) continue;
            return smallest;
        }
        return null;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public GroupValues<T> getKnownValues() {
        return new GroupValues<T>(this.knownValues);
    }

    @Override
    public void addRule(RuleConstraint<T> ruleConstraint) {
        this.rules.add(ruleConstraint);
    }
}

