/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.analyze;

import java.util.ArrayList;
import java.util.Collection;
import net.zomis.minesweeper.analyze.BoundedFieldRule;
import net.zomis.minesweeper.analyze.Combinatorics;
import net.zomis.minesweeper.analyze.FieldGroup;

public class FieldRule<T>
extends BoundedFieldRule<T> {
    private FieldRule(FieldRule<T> copyFrom) {
        super(copyFrom.getCause(), copyFrom.fields, copyFrom.getResult(), copyFrom.getResult());
    }

    public FieldRule(T cause, Collection<T> rule, int result) {
        super(cause, rule, result, result);
    }

    FieldRule(T cause, FieldGroup<T> group, int result) {
        super(cause, new ArrayList(), result, result);
        this.fields.add(group);
    }

    public Collection<FieldGroup<T>> getFieldGroups() {
        return new ArrayList<FieldGroup<T>>(this.fields);
    }

    public int getFieldsCountInGroups() {
        int fieldsCounter = 0;
        for (FieldGroup group : this.fields) {
            fieldsCounter += group.size();
        }
        return fieldsCounter;
    }

    public int getResult() {
        return this.getMinResult();
    }

    public double nCr() {
        if (this.fields.size() != 1) {
            throw new IllegalStateException("Rule has more than one group.");
        }
        return Combinatorics.nCr(this.getFieldsCountInGroups(), this.minResult);
    }

    @Override
    public int getMaxResult() {
        return this.getMinResult();
    }

    @Override
    public String toString() {
        StringBuilder rule = new StringBuilder();
        for (FieldGroup field : this.fields) {
            if (rule.length() > 0) {
                rule.append(" + ");
            }
            rule.append(field.toString());
        }
        rule.append(" = ");
        rule.append(this.getResult());
        return rule.toString();
    }

    @Override
    public FieldRule<T> copy() {
        return new FieldRule<T>(this);
    }
}

