/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.analyze;

import java.util.Collections;
import java.util.HashSet;
import net.zomis.minesweeper.analyze.FieldGroup;

public class FieldGroupSplit<T> {
    private final FieldGroup<T> onlyA;
    private final FieldGroup<T> both;
    private final FieldGroup<T> onlyB;

    private FieldGroupSplit(FieldGroup<T> onlyA, FieldGroup<T> both, FieldGroup<T> onlyB) {
        this.onlyA = onlyA;
        this.onlyB = onlyB;
        this.both = both;
    }

    public FieldGroup<T> getBoth() {
        return this.both;
    }

    public FieldGroup<T> getOnlyA() {
        return this.onlyA;
    }

    public FieldGroup<T> getOnlyB() {
        return this.onlyB;
    }

    public boolean splitPerformed() {
        return !this.onlyA.isEmpty() || !this.onlyB.isEmpty();
    }

    public String toString() {
        return "FieldGroupSplit:" + this.onlyA + " -- " + this.both + " -- " + this.onlyB;
    }

    public static <T> FieldGroupSplit<T> split(FieldGroup<T> a, FieldGroup<T> b) {
        if (a == b) {
            return null;
        }
        if (Collections.disjoint(a, b)) {
            return null;
        }
        FieldGroup<T> both = new FieldGroup<T>(a);
        FieldGroup<T> onlyA = new FieldGroup<T>(a);
        FieldGroup<T> onlyB = new FieldGroup<T>(b);
        both.retainAll(b);
        onlyA.removeAll(both);
        onlyB.removeAll(both);
        if (onlyA.isEmpty() && onlyB.isEmpty()) {
            both = a;
        }
        return new FieldGroupSplit<T>(onlyA, both, onlyB);
    }

    public static final <T> FieldGroupSplit<T> splitHash(FieldGroup<T> a, FieldGroup<T> b) {
        if (a == b || a.isEmpty() || b.isEmpty()) {
            return null;
        }
        boolean aIsSmall = a.size() <= b.size();
        FieldGroup<T> smallestGroup = aIsSmall ? a : b;
        HashSet<T> setBig = new HashSet<T>(aIsSmall ? b : a);
        HashSet setBoth = new HashSet(smallestGroup.size());
        FieldGroup aOnly = new FieldGroup(a.size());
        FieldGroup bOnly = new FieldGroup(b.size());
        FieldGroup smallOnly = aIsSmall ? aOnly : bOnly;
        FieldGroup bigOnly = aIsSmall ? bOnly : aOnly;
        for (Object val : smallestGroup) {
            if (setBig.contains(val)) {
                setBoth.add(val);
                continue;
            }
            smallOnly.add(val);
        }
        if (setBoth.isEmpty()) {
            return null;
        }
        for (Object val : setBig) {
            if (setBoth.contains(val)) continue;
            bigOnly.add(val);
        }
        return new FieldGroupSplit(aOnly, aOnly.isEmpty() && bOnly.isEmpty() ? a : new FieldGroup<T>(setBoth), bOnly);
    }
}

