/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.analyze;

import java.util.ArrayList;
import java.util.Collection;
import net.zomis.minesweeper.analyze.Solution;

public class FieldGroup<T>
extends ArrayList<T> {
    private static final long serialVersionUID = 4172065050118874050L;
    private double probability = 0.0;
    private int solutionsKnown = 0;

    public FieldGroup(Collection<T> fields) {
        super(fields);
    }

    FieldGroup(int size) {
        super(size);
    }

    public double getProbability() {
        return this.probability;
    }

    public int getSolutionsKnown() {
        return this.solutionsKnown;
    }

    void informAboutSolution(int minesForGroup, Solution<T> solution, double total) {
        if (minesForGroup == 0) {
            return;
        }
        this.probability += solution.nCr() / total * (double)minesForGroup / (double)this.size();
        ++this.solutionsKnown;
    }

    @Override
    public String toString() {
        if (this.size() > 8) {
            return "(" + this.size() + " FIELDS)";
        }
        StringBuilder str = new StringBuilder();
        for (Object field : this) {
            if (str.length() > 0) {
                str.append(" + ");
            }
            str.append(field);
        }
        return "(" + str.toString() + ")";
    }
}

