/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.analyze;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.zomis.minesweeper.analyze.FieldGroup;
import net.zomis.minesweeper.analyze.GroupValues;
import net.zomis.minesweeper.analyze.RuleConstraint;
import net.zomis.minesweeper.analyze.SimplifyResult;
import net.zomis.minesweeper.analyze.listener.RuleListener;

public class BoundedFieldRule<T>
implements RuleConstraint<T> {
    private final T cause;
    protected final List<FieldGroup<T>> fields;
    protected int maxResult = 0;
    protected int minResult = 0;

    private BoundedFieldRule(BoundedFieldRule<T> copyFrom) {
        this.cause = copyFrom.cause;
        this.fields = new ArrayList<FieldGroup<T>>(copyFrom.fields);
        this.minResult = copyFrom.minResult;
        this.maxResult = copyFrom.maxResult;
    }

    public BoundedFieldRule(T cause, Collection<T> rule, int min, int max) {
        this.cause = cause;
        this.fields = new ArrayList<FieldGroup<T>>();
        this.fields.add(new FieldGroup<T>(rule));
        this.minResult = min;
        this.maxResult = max;
    }

    public BoundedFieldRule(T cause, List<FieldGroup<T>> fields, int min, int max) {
        this.cause = cause;
        this.fields = new ArrayList<FieldGroup<T>>(fields);
        this.minResult = min;
        this.maxResult = max;
    }

    @Override
    public boolean isEmpty() {
        return this.fields.isEmpty() && this.minResult <= 0 && this.maxResult >= 0;
    }

    @Override
    public SimplifyResult simplify(GroupValues<T> knownValues, RuleListener<T> listener) {
        if (this.isEmpty()) {
            return SimplifyResult.NO_EFFECT;
        }
        Iterator<FieldGroup<T>> it = this.fields.iterator();
        int totalCount = 0;
        while (it.hasNext()) {
            FieldGroup<T> group = it.next();
            Integer known = knownValues.get(group);
            if (known != null) {
                it.remove();
                this.minResult -= known.intValue();
                this.maxResult -= known.intValue();
                continue;
            }
            totalCount += group.size();
        }
        if (this.maxResult < 0) {
            return SimplifyResult.FAILED_NEGATIVE_RESULT;
        }
        if (this.minResult > totalCount) {
            return SimplifyResult.FAILED_TOO_BIG_RESULT;
        }
        if (this.fields.size() == 1 && this.minResult == this.maxResult) {
            knownValues.put(this.fields.get(0), this.minResult);
            listener.onValueSet(this.fields.get(0), this.minResult);
            return this.clearRule();
        }
        if (this.maxResult == 0) {
            for (FieldGroup<T> field : this.fields) {
                knownValues.put(field, 0);
                listener.onValueSet(field, 0);
            }
            return this.clearRule();
        }
        if (totalCount == this.minResult) {
            for (FieldGroup<T> field : this.fields) {
                int value = this.minResult * field.size() / totalCount;
                knownValues.put(field, value);
                listener.onValueSet(field, value);
            }
            return this.clearRule();
        }
        if (this.minResult <= 0 && this.maxResult >= totalCount) {
            this.clearRule();
        }
        return SimplifyResult.NO_EFFECT;
    }

    private SimplifyResult clearRule() {
        SimplifyResult simplifyResult = this.fields.isEmpty() ? SimplifyResult.NO_EFFECT : SimplifyResult.SIMPLIFIED;
        this.fields.clear();
        this.minResult = 0;
        this.maxResult = 0;
        return simplifyResult;
    }

    public String toString() {
        StringBuilder rule = new StringBuilder();
        rule.append(this.minResult);
        rule.append(" <= ");
        boolean fieldAdded = false;
        for (FieldGroup<T> field : this.fields) {
            if (fieldAdded) {
                rule.append(" + ");
            }
            fieldAdded = true;
            rule.append(field.toString());
        }
        rule.append(" <= ");
        rule.append(this.maxResult);
        return rule.toString();
    }

    @Override
    public BoundedFieldRule<T> copy() {
        return new BoundedFieldRule<T>(this);
    }

    @Override
    public List<FieldGroup<T>> fieldGroups() {
        return this.fields;
    }

    @Override
    public FieldGroup<T> getSmallestFieldGroup() {
        if (this.fields.isEmpty()) {
            return null;
        }
        FieldGroup<T> result = this.fields.get(0);
        for (FieldGroup<T> group : this.fields) {
            int size = group.size();
            if (size == 1) {
                return group;
            }
            if (size >= result.size()) continue;
            result = group;
        }
        return result;
    }

    @Override
    public T getCause() {
        return this.cause;
    }

    public int getMinResult() {
        return this.minResult;
    }

    public int getMaxResult() {
        return this.maxResult;
    }
}

