/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.analyze;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.zomis.minesweeper.analyze.AnalyzeResult;
import net.zomis.minesweeper.analyze.AnalyzeResultsImpl;
import net.zomis.minesweeper.analyze.FieldGroup;
import net.zomis.minesweeper.analyze.FieldGroupSplit;
import net.zomis.minesweeper.analyze.FieldRule;
import net.zomis.minesweeper.analyze.GameAnalyze;
import net.zomis.minesweeper.analyze.RuleConstraint;
import net.zomis.minesweeper.analyze.Solution;
import net.zomis.minesweeper.analyze.listener.Analyze;
import net.zomis.minesweeper.analyze.listener.SolveListener;

public class AnalyzeFactory<T> {
    private final List<RuleConstraint<T>> rules = new ArrayList<RuleConstraint<T>>();
    private SolveListener<T> listener;

    AnalyzeFactory(Solution<T> known, List<RuleConstraint<T>> rules) {
        for (Map.Entry<FieldGroup<T>, Integer> sol : known.getSetGroupValues().entrySet()) {
            this.rules.add(new FieldRule<Object>(null, (FieldGroup<Object>)sol.getKey(), (int)sol.getValue()));
        }
        this.rules.addAll(rules);
    }

    public AnalyzeFactory() {
    }

    public AnalyzeResult<T> solve() {
        ArrayList original = new ArrayList(this.rules.size());
        for (RuleConstraint<T> ruleConstraint : this.rules) {
            original.add(ruleConstraint.copy());
        }
        ArrayList<RuleConstraint<T>> inProgress = new ArrayList<RuleConstraint<T>>(this.rules.size());
        for (RuleConstraint<T> ruleConstraint : this.rules) {
            inProgress.add(ruleConstraint.copy());
        }
        ArrayList arrayList = new ArrayList();
        AnalyzeFactory.splitFieldRules(inProgress);
        SolveListener solveListener = this.listener != null ? this.listener : new SolveListener<T>(){

            @Override
            public void onValueSet(Analyze<T> analyze, FieldGroup<T> group, int value) {
            }
        };
        GameAnalyze analyze = new GameAnalyze(null, inProgress, 0, solveListener);
        double total = analyze.solve(arrayList);
        for (Solution solution : arrayList) {
            solution.setTotal(total);
        }
        ArrayList groups = new ArrayList();
        if (!arrayList.isEmpty()) {
            for (FieldGroup fieldGroup : ((Solution)arrayList.get(0)).getSetGroupValues().keySet()) {
                groups.add(fieldGroup);
            }
        }
        AnalyzeResultsImpl analyzeResultsImpl = new AnalyzeResultsImpl(original, inProgress, groups, arrayList, total);
        return analyzeResultsImpl;
    }

    public static <T> void splitFieldRules(List<RuleConstraint<T>> rules) {
        if (rules.size() <= 1) {
            return;
        }
        boolean splitPerformed = true;
        while (splitPerformed) {
            splitPerformed = false;
            for (RuleConstraint<T> a : rules) {
                for (RuleConstraint<T> b : rules) {
                    splitPerformed |= AnalyzeFactory.checkIntersection(a, b);
                }
            }
        }
    }

    private static <T> boolean checkIntersection(RuleConstraint<T> ruleA, RuleConstraint<T> ruleB) {
        if (ruleA == ruleB) {
            return false;
        }
        List<FieldGroup<T>> fieldsA = ruleA.fieldGroups();
        List<FieldGroup<T>> fieldsB = ruleB.fieldGroups();
        ArrayList<FieldGroup<T>> fieldsCopy = new ArrayList<FieldGroup<T>>(ruleA.fieldGroups());
        ArrayList<FieldGroup<T>> ruleFieldsCopy = new ArrayList<FieldGroup<T>>(ruleB.fieldGroups());
        for (FieldGroup fieldGroup : fieldsCopy) {
            for (FieldGroup fieldGroup2 : ruleFieldsCopy) {
                FieldGroupSplit splitResult;
                if (fieldGroup == fieldGroup2 || (splitResult = FieldGroupSplit.split(fieldGroup, fieldGroup2)) == null) continue;
                FieldGroup both = splitResult.getBoth();
                FieldGroup onlyA = splitResult.getOnlyA();
                FieldGroup onlyB = splitResult.getOnlyB();
                fieldsA.remove(fieldGroup);
                fieldsA.add(both);
                if (!onlyA.isEmpty()) {
                    fieldsA.add(onlyA);
                }
                fieldsB.remove(fieldGroup2);
                fieldsB.add(both);
                if (!onlyB.isEmpty()) {
                    fieldsB.add(onlyB);
                }
                return true;
            }
        }
        return false;
    }

    public void splitFieldRules() {
        AnalyzeFactory.splitFieldRules(this.rules);
    }

    public AnalyzeFactory<T> addRule(RuleConstraint<T> rule) {
        this.rules.add(rule);
        return this;
    }

    public AnalyzeFactory<T> setListener(SolveListener<T> listener) {
        this.listener = listener;
        return this;
    }

    public SolveListener<T> getListener() {
        return this.listener;
    }

    public List<RuleConstraint<T>> getRules() {
        return new ArrayList<RuleConstraint<T>>(this.rules);
    }
}

