/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.analyze.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.zomis.minesweeper.analyze.AnalyzeFactory;
import net.zomis.minesweeper.analyze.FieldRule;
import net.zomis.minesweeper.analyze.detail.NeighborFind;

public abstract class AbstractAnalyze<F>
extends AnalyzeFactory<F>
implements NeighborFind<F> {
    protected abstract List<F> getAllPoints();

    protected final void createRules(List<F> points) {
        HashSet knownNonMines = new HashSet();
        int remaining = this.getRemainingMinesCount();
        if (remaining != -1) {
            this.addRule(new FieldRule<Object>(null, this.getAllUnclickedFields(), remaining));
        }
        for (F field : points) {
            FieldRule<F> newRule;
            if (!this.fieldHasRule(field) || (newRule = this.internalRuleFromField(field, knownNonMines)) == null) continue;
            this.addRule(newRule);
        }
        if (!knownNonMines.isEmpty()) {
            this.addRule(new FieldRule<Object>(null, knownNonMines, 0));
        }
    }

    protected abstract boolean fieldHasRule(F var1);

    protected abstract int getRemainingMinesCount();

    protected abstract List<F> getAllUnclickedFields();

    private FieldRule<F> internalRuleFromField(F field, Set<F> knownNonMines) {
        ArrayList<F> ruleParams = new ArrayList<F>();
        int foundNeighbors = 0;
        int fieldValue = this.getFieldValue(field);
        for (F neighbor : this.getNeighbors(field)) {
            if (this.isDiscoveredMine(neighbor)) {
                ++foundNeighbors;
                continue;
            }
            if (this.isClicked(neighbor)) continue;
            ruleParams.add(neighbor);
        }
        if (fieldValue - foundNeighbors == 0) {
            if (knownNonMines != null) {
                for (Object mf : ruleParams) {
                    if (knownNonMines.contains(mf)) continue;
                    knownNonMines.add(mf);
                }
            }
            return null;
        }
        return new FieldRule<F>(field, ruleParams, fieldValue - foundNeighbors);
    }

    protected abstract boolean isDiscoveredMine(F var1);

    protected abstract int getFieldValue(F var1);

    protected abstract List<F> getNeighbors(F var1);

    protected abstract boolean isClicked(F var1);

    @Override
    public Collection<F> getNeighborsFor(F field) {
        return this.getNeighbors(field);
    }

    @Override
    public boolean isFoundAndisMine(F field) {
        return this.isDiscoveredMine(field);
    }

    public void createRules() {
        this.createRules(this.getAllPoints());
    }
}

