/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.analyze.detail;

import java.util.HashMap;
import net.zomis.minesweeper.analyze.AnalyzeResult;
import net.zomis.minesweeper.analyze.FieldGroup;
import net.zomis.minesweeper.analyze.Solution;
import net.zomis.minesweeper.analyze.detail.DetailedResults;
import net.zomis.minesweeper.analyze.detail.DetailedResultsImpl;
import net.zomis.minesweeper.analyze.detail.FieldProxy;
import net.zomis.minesweeper.analyze.detail.NeighborFind;
import net.zomis.minesweeper.analyze.detail.ProxyProvider;

public class DetailAnalyze {
    public static <T> DetailedResults<T> solveDetailed(AnalyzeResult<T> analyze, NeighborFind<T> neighborStrategy) {
        final HashMap proxies = new HashMap();
        for (FieldGroup<T> fieldGroup : analyze.getGroups()) {
            for (Object field : fieldGroup) {
                FieldProxy<T> proxy = new FieldProxy<T>(fieldGroup, field);
                proxies.put(field, proxy);
            }
        }
        ProxyProvider provider = new ProxyProvider<T>(){

            @Override
            public FieldProxy<T> getProxyFor(T field) {
                return (FieldProxy)proxies.get(field);
            }
        };
        for (FieldProxy fieldProxy : proxies.values()) {
            fieldProxy.fixNeighbors(neighborStrategy, provider);
        }
        double d = analyze.getTotal();
        HashMap bufferedValues = new HashMap();
        for (FieldProxy proxy : proxies.values()) {
            FieldProxy bufferedValue = (FieldProxy)bufferedValues.get(proxy.getNeighbors());
            if (bufferedValue != null && bufferedValue.getFieldGroup() == proxy.getFieldGroup()) {
                proxy.copyFromOther(bufferedValue, d);
                continue;
            }
            for (Solution<T> solution : analyze.getSolutionIteration()) {
                proxy.addSolution(solution);
            }
            proxy.finalCalculation(d);
            bufferedValues.put(proxy.getNeighbors(), proxy);
        }
        int proxyCount = bufferedValues.size();
        return new DetailedResultsImpl<T>(analyze, proxies, proxyCount);
    }
}

