/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.analyze;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.zomis.minesweeper.analyze.FieldGroup;
import net.zomis.minesweeper.analyze.GroupValues;
import net.zomis.minesweeper.analyze.RuleConstraint;
import net.zomis.minesweeper.analyze.RuntimeTimeoutException;
import net.zomis.minesweeper.analyze.SimplifyResult;
import net.zomis.minesweeper.analyze.Solution;
import net.zomis.minesweeper.analyze.SolvedCallback;

public class GameAnalyze<T> {
    @Deprecated
    private final SolvedCallback<T> callback;
    private final GroupValues<T> knownValues;
    private final List<RuleConstraint<T>> rules;

    GameAnalyze(GroupValues<T> knownValues, List<RuleConstraint<T>> unsolvedRules, SolvedCallback<T> callback) {
        this.knownValues = knownValues == null ? new GroupValues() : new GroupValues<T>(knownValues);
        this.rules = unsolvedRules;
        this.callback = callback;
    }

    private void removeEmptyRules() {
        Iterator<RuleConstraint<T>> it = this.rules.iterator();
        while (it.hasNext()) {
            if (!it.next().isEmpty()) continue;
            it.remove();
        }
    }

    private boolean simplifyRules() {
        boolean simplifyPerformed = true;
        while (simplifyPerformed) {
            simplifyPerformed = false;
            Iterator<RuleConstraint<T>> it = this.rules.iterator();
            while (it.hasNext()) {
                RuleConstraint<T> ruleSimplify = it.next();
                SimplifyResult simplifyResult = ruleSimplify.simplify(this.knownValues);
                if (simplifyResult == SimplifyResult.SIMPLIFIED) {
                    simplifyPerformed = true;
                } else if (simplifyResult.isFailure()) {
                    return false;
                }
                if (!ruleSimplify.isEmpty()) continue;
                it.remove();
            }
        }
        return true;
    }

    double solve(List<Solution<T>> solutions) {
        if (!this.simplifyRules()) {
            return 0.0;
        }
        this.removeEmptyRules();
        double total = this.solveRules(solutions);
        if (this.rules.isEmpty()) {
            Solution<T> solved = Solution.createSolution(this.knownValues);
            solutions.add(solved);
            total += solved.nCr();
        }
        return total;
    }

    private double solveRules(List<Solution<T>> solutions) {
        if (Thread.interrupted()) {
            throw new RuntimeTimeoutException();
        }
        if (this.rules.isEmpty()) {
            return 0.0;
        }
        FieldGroup<T> chosenGroup = this.getSmallestFieldGroup();
        if (chosenGroup == null) {
            throw new IllegalStateException("Chosen group is null: " + this.rules);
        }
        int groupSize = chosenGroup.size();
        if (groupSize == 0) {
            throw new IllegalStateException("Chosen group is empty. " + chosenGroup);
        }
        double total = 0.0;
        for (int i = 0; i <= groupSize; ++i) {
            GroupValues<T> mapCopy = new GroupValues<T>(this.knownValues);
            mapCopy.put(chosenGroup, i);
            ArrayList<RuleConstraint<T>> rulesCopy = new ArrayList<RuleConstraint<T>>();
            for (RuleConstraint<T> rule : this.rules) {
                rulesCopy.add(rule.copy());
            }
            total += new GameAnalyze<T>(mapCopy, rulesCopy, this.callback).solve(solutions);
        }
        return total;
    }

    private FieldGroup<T> getSmallestFieldGroup() {
        for (RuleConstraint<T> rule : this.rules) {
            FieldGroup<T> smallest = rule.getSmallestFieldGroup();
            if (smallest == null) continue;
            return smallest;
        }
        return null;
    }
}

