/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.analyze.detail;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.zomis.minesweeper.analyze.Combinatorics;
import net.zomis.minesweeper.analyze.FieldGroup;
import net.zomis.minesweeper.analyze.GroupValues;
import net.zomis.minesweeper.analyze.RuntimeTimeoutException;
import net.zomis.minesweeper.analyze.Solution;
import net.zomis.minesweeper.analyze.detail.NeighborFind;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.analyze.detail.ProxyProvider;

public class FieldProxy<T>
implements ProbabilityKnowledge<T> {
    private double[] detailedCombinations;
    private double[] detailedProbabilities;
    private final T field;
    private int found;
    private final FieldGroup<T> group;
    private final GroupValues<T> neighbors;

    private static int minK(int N, int K, int n) {
        return N == K ? n : 0;
    }

    public FieldProxy(FieldGroup<T> group, T field) {
        this.field = field;
        this.neighbors = new GroupValues();
        this.group = group;
        this.found = 0;
    }

    void addSolution(Solution<T> solution) {
        this.recursiveRemove(new ArrayList<Map.Entry<FieldGroup<T>, Integer>>(solution.copyWithoutNCRData().getSetGroupValues().entrySet()), 1.0, 0, 0);
    }

    void copyFromOther(FieldProxy<T> copyFrom, double analyzeTotal) {
        System.arraycopy(copyFrom.detailedCombinations, copyFrom.found, this.detailedCombinations, this.found, Math.min(this.detailedCombinations.length - this.found, copyFrom.detailedCombinations.length - copyFrom.found));
        this.finalCalculation(analyzeTotal);
    }

    void finalCalculation(double analyzeTotal) {
        this.detailedProbabilities = new double[this.detailedCombinations.length];
        for (int i = 0; i < this.detailedProbabilities.length; ++i) {
            this.detailedProbabilities[i] = this.detailedCombinations[i] / analyzeTotal;
        }
    }

    void fixNeighbors(NeighborFind<T> neighborStrategy, ProxyProvider<T> proxyProvider) {
        Collection<T> realNeighbors = neighborStrategy.getNeighborsFor(this.field);
        this.detailedCombinations = new double[realNeighbors.size() + 1];
        for (T neighbor : realNeighbors) {
            FieldGroup<T> neighborGroup;
            if (neighborStrategy.isFoundAndisMine(neighbor)) {
                ++this.found;
                continue;
            }
            FieldProxy<T> proxy = proxyProvider.getProxyFor(neighbor);
            if (proxy == null || (neighborGroup = proxy.group) == null || neighborGroup.getProbability() == 0.0) continue;
            Integer currentNeighborAmount = this.neighbors.get(neighborGroup);
            if (currentNeighborAmount == null) {
                this.neighbors.put(neighborGroup, 1);
                continue;
            }
            this.neighbors.put(neighborGroup, currentNeighborAmount + 1);
        }
    }

    @Override
    public T getField() {
        return this.field;
    }

    @Override
    public FieldGroup<T> getFieldGroup() {
        return this.group;
    }

    @Override
    public int getFound() {
        return this.found;
    }

    @Override
    public double getMineProbability() {
        return this.group.getProbability();
    }

    @Override
    public GroupValues<T> getNeighbors() {
        return this.neighbors;
    }

    @Override
    public double[] getProbabilities() {
        return this.detailedProbabilities;
    }

    private void recursiveRemove(List<Map.Entry<FieldGroup<T>, Integer>> solution, double combinations, int mines, int listIndex) {
        if (Thread.interrupted()) {
            throw new RuntimeTimeoutException();
        }
        if (listIndex >= solution.size()) {
            int n = mines + this.found;
            this.detailedCombinations[n] = this.detailedCombinations[n] + combinations;
            return;
        }
        Map.Entry<FieldGroup<T>, Integer> fieldGroupAssignment = solution.get(listIndex);
        FieldGroup<T> group = fieldGroupAssignment.getKey();
        int N = group.size();
        int n = fieldGroupAssignment.getValue();
        Integer K = this.neighbors.get(group);
        if (this.group == group) {
            --N;
        }
        if (K == null) {
            this.recursiveRemove(solution, combinations * Combinatorics.nCr(N, n), mines, listIndex + 1);
            return;
        }
        int maxLoop = Math.min(K, n);
        for (int k = FieldProxy.minK(N, K, n); k <= maxLoop; ++k) {
            double thisCombinations = Combinatorics.NNKK(N, n, K, k);
            this.recursiveRemove(solution, combinations * thisCombinations, mines + k, listIndex + 1);
        }
    }

    public String toString() {
        return "Proxy(" + this.field.toString() + ")" + "\n neighbors: " + this.neighbors.toString() + "\n group: " + this.group.toString() + "\n Mine prob " + this.group.getProbability() + " Numbers: " + Arrays.toString(this.detailedProbabilities);
    }
}

