/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.analyze.factory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.zomis.minesweeper.analyze.factory.AbstractAnalyze;
import net.zomis.minesweeper.analyze.factory.CharPoint;

public class General2DAnalyze
extends AbstractAnalyze<CharPoint> {
    public static final char[] UNCLICKED = new char[]{'_', '?'};
    public static final char HIDDEN_MINE = 'x';
    public static final char KNOWN_MINE = '!';
    public static final char BLOCKED = '#';
    private static final int[][] DEFAULT_NEIGHBORS = new int[][]{{-1, -1}, {0, -1}, {1, -1}, {-1, 0}, {1, 0}, {-1, 1}, {0, 1}, {1, 1}};
    private final int[][] neighbors;
    private final CharPoint[][] points;
    private final int width;
    private final int height;
    private final int hiddenMines;

    public General2DAnalyze(String[] map) {
        this(map, 0);
    }

    public General2DAnalyze(String[] map, int hiddenMines) {
        this(map, hiddenMines, DEFAULT_NEIGHBORS);
    }

    public General2DAnalyze(String[] map, int hiddenMines, int[][] neighbors) {
        for (int[] neighbor : neighbors) {
            if (neighbor.length == 2) continue;
            throw new IllegalArgumentException("Neighbor array must be an array of int[2] (x, y) pair. Unexpected length " + neighbor.length + " for " + Arrays.toString(neighbor));
        }
        this.width = map[0].length();
        this.height = map.length;
        this.points = new CharPoint[this.width][this.height];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                char ch = map[y].charAt(x);
                if (!this.isValidChar(ch)) {
                    throw new IllegalArgumentException("'" + ch + "' is not a valid character");
                }
                this.points[x][y] = new CharPoint(x, y, ch);
                if (ch != 'x') continue;
                ++hiddenMines;
            }
        }
        this.hiddenMines = hiddenMines;
        this.neighbors = neighbors;
        this.createRules(this.getAllPoints());
    }

    private boolean isValidChar(char ch) {
        return Character.isDigit(ch) || ch == '#' || ch == 'x' || ch == '!' || this.isInArray(ch, UNCLICKED);
    }

    @Override
    protected List<CharPoint> getAllPoints() {
        ArrayList<CharPoint> point = new ArrayList<CharPoint>();
        CharPoint[][] charPointArray = this.points;
        int n = charPointArray.length;
        for (int i = 0; i < n; ++i) {
            CharPoint[] ps;
            for (CharPoint p : ps = charPointArray[i]) {
                point.add(p);
            }
        }
        return point;
    }

    @Override
    protected boolean fieldHasRule(CharPoint field) {
        return !this.isBlocked(field) && this.isClicked(field) && !this.isDiscoveredMine(field);
    }

    private boolean isBlocked(CharPoint field) {
        return field.getValue() == '#';
    }

    @Override
    protected int getRemainingMinesCount() {
        return this.hiddenMines;
    }

    @Override
    protected List<CharPoint> getAllUnclickedFields() {
        ArrayList<CharPoint> point = new ArrayList<CharPoint>();
        CharPoint[][] charPointArray = this.points;
        int n = charPointArray.length;
        for (int i = 0; i < n; ++i) {
            CharPoint[] ps;
            for (CharPoint p : ps = charPointArray[i]) {
                if (this.isClicked(p)) continue;
                point.add(p);
            }
        }
        return point;
    }

    @Override
    protected boolean isDiscoveredMine(CharPoint neighbor) {
        return neighbor.getValue() == '!';
    }

    @Override
    protected int getFieldValue(CharPoint field) {
        return Character.digit(field.getValue(), 10);
    }

    @Override
    protected List<CharPoint> getNeighbors(CharPoint field) {
        ArrayList<CharPoint> neighbors = new ArrayList<CharPoint>(this.neighbors.length);
        int x = field.getX();
        int y = field.getY();
        for (int xx = x - 1; xx <= x + 1; ++xx) {
            for (int yy = y - 1; yy <= y + 1; ++yy) {
                if (xx == x && yy == y || xx < 0 || yy < 0 || xx >= this.width || yy >= this.height) continue;
                neighbors.add(this.points[xx][yy]);
            }
        }
        return neighbors;
    }

    @Override
    protected boolean isClicked(CharPoint neighbor) {
        if (this.isBlocked(neighbor)) {
            return true;
        }
        return !this.isUnclickedChar(neighbor.getValue()) && neighbor.getValue() != 'x';
    }

    private boolean isUnclickedChar(char value) {
        return this.isInArray(value, UNCLICKED);
    }

    private boolean isInArray(char value, char[] array) {
        for (char ch : array) {
            if (ch != value) continue;
            return true;
        }
        return false;
    }

    public CharPoint getPoint(int x, int y) {
        return this.points[x][y];
    }
}

