/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.analyze;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.zomis.minesweeper.analyze.Combinatorics;
import net.zomis.minesweeper.analyze.FieldGroup;
import net.zomis.minesweeper.analyze.FieldGroupSplit;
import net.zomis.minesweeper.analyze.GroupValues;
import net.zomis.minesweeper.analyze.SimplifyResult;

public class FieldRule<T> {
    private final T cause;
    private final List<FieldGroup<T>> fields;
    private int result = 0;

    public FieldRule(FieldRule<T> copyFrom) {
        this.fields = new ArrayList<FieldGroup<T>>(copyFrom.fields);
        this.result = copyFrom.result;
        this.cause = copyFrom.cause;
    }

    public FieldRule(T cause, Collection<T> rule, int result) {
        this.fields = new ArrayList<FieldGroup<T>>();
        this.fields.add(new FieldGroup<T>(rule));
        this.result = result;
        this.cause = cause;
    }

    FieldRule(T cause, FieldGroup<T> group, int result) {
        this.cause = cause;
        this.fields = new ArrayList<FieldGroup<T>>();
        this.fields.add(group);
        this.result = result;
    }

    boolean checkIntersection(FieldRule<T> rule) {
        if (rule == this) {
            return false;
        }
        ArrayList<FieldGroup<T>> fieldsCopy = new ArrayList<FieldGroup<T>>(this.fields);
        ArrayList<FieldGroup<T>> ruleFieldsCopy = new ArrayList<FieldGroup<T>>(rule.fields);
        for (FieldGroup fieldGroup : fieldsCopy) {
            for (FieldGroup fieldGroup2 : ruleFieldsCopy) {
                FieldGroupSplit splitResult;
                if (fieldGroup == fieldGroup2 || (splitResult = FieldGroupSplit.split(fieldGroup, fieldGroup2)) == null) continue;
                FieldGroup both = splitResult.getBoth();
                FieldGroup onlyA = splitResult.getOnlyA();
                FieldGroup onlyB = splitResult.getOnlyB();
                this.fields.remove(fieldGroup);
                this.fields.add(both);
                if (!onlyA.isEmpty()) {
                    this.fields.add(onlyA);
                }
                rule.fields.remove(fieldGroup2);
                rule.fields.add(both);
                if (!onlyB.isEmpty()) {
                    rule.fields.add(onlyB);
                }
                return true;
            }
        }
        return false;
    }

    public T getCause() {
        return this.cause;
    }

    public Collection<FieldGroup<T>> getFieldGroups() {
        return new ArrayList<FieldGroup<T>>(this.fields);
    }

    public int getFieldsCountInGroups() {
        int fieldsCounter = 0;
        for (FieldGroup<T> group : this.fields) {
            fieldsCounter += group.size();
        }
        return fieldsCounter;
    }

    public int getResult() {
        return this.result;
    }

    public FieldGroup<T> getSmallestFieldGroup() {
        if (this.fields.isEmpty()) {
            return null;
        }
        FieldGroup<T> result = this.fields.get(0);
        for (FieldGroup<T> group : this.fields) {
            if (group.size() >= result.size()) continue;
            result = group;
        }
        return result;
    }

    public boolean isEmpty() {
        return this.fields.isEmpty() && this.result == 0;
    }

    public double nCr() {
        if (this.fields.size() != 1) {
            throw new IllegalStateException("Rule has more than one group.");
        }
        return Combinatorics.nCr(this.getFieldsCountInGroups(), this.result);
    }

    public SimplifyResult simplify(GroupValues<T> knownValues) {
        if (this.isEmpty()) {
            return SimplifyResult.NO_EFFECT;
        }
        Iterator<FieldGroup<T>> it = this.fields.iterator();
        int totalCount = 0;
        while (it.hasNext()) {
            FieldGroup<T> group = it.next();
            Integer known = knownValues.get(group);
            if (known != null) {
                it.remove();
                this.result -= known.intValue();
                continue;
            }
            totalCount += group.size();
        }
        if (this.result < 0) {
            return SimplifyResult.FAILED_NEGATIVE_RESULT;
        }
        if (this.result > totalCount) {
            return SimplifyResult.FAILED_TOO_BIG_RESULT;
        }
        if (this.fields.size() == 1) {
            knownValues.put(this.fields.get(0), this.result);
            this.fields.clear();
            this.result = 0;
            return SimplifyResult.SIMPLIFIED;
        }
        if (this.result == 0) {
            for (FieldGroup<T> field : this.fields) {
                knownValues.put(field, 0);
            }
            this.fields.clear();
            this.result = 0;
            return SimplifyResult.SIMPLIFIED;
        }
        if (totalCount == this.result) {
            for (FieldGroup<T> field : this.fields) {
                knownValues.put(field, this.result * field.size() / totalCount);
            }
            return SimplifyResult.SIMPLIFIED;
        }
        return SimplifyResult.NO_EFFECT;
    }

    public String toString() {
        StringBuilder rule = new StringBuilder();
        for (FieldGroup<T> field : this.fields) {
            if (rule.length() > 0) {
                rule.append(" + ");
            }
            rule.append(field.toString());
        }
        rule.append(" = ");
        rule.append(this.result);
        return rule.toString();
    }
}

