/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.analyze;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.zomis.minesweeper.analyze.AnalyzeResult;
import net.zomis.minesweeper.analyze.AnalyzeResultsImpl;
import net.zomis.minesweeper.analyze.FieldGroup;
import net.zomis.minesweeper.analyze.FieldRule;
import net.zomis.minesweeper.analyze.GameAnalyze;
import net.zomis.minesweeper.analyze.Solution;

public class AnalyzeFactory<T> {
    private final List<FieldRule<T>> rules = new ArrayList<FieldRule<T>>();

    AnalyzeFactory(Solution<T> known, List<FieldRule<T>> rules) {
        for (Map.Entry<FieldGroup<T>, Integer> sol : known.getSetGroupValues().entrySet()) {
            this.rules.add(new FieldRule<Object>(null, (FieldGroup<Object>)sol.getKey(), (int)sol.getValue()));
        }
        this.rules.addAll(rules);
    }

    public AnalyzeFactory() {
    }

    public AnalyzeResult<T> solve() {
        ArrayList original = new ArrayList(this.rules.size());
        for (FieldRule<T> fieldRule : this.rules) {
            original.add(new FieldRule<T>(fieldRule));
        }
        ArrayList<FieldRule<T>> inProgress = new ArrayList<FieldRule<T>>(this.rules.size());
        for (FieldRule<T> fieldRule : this.rules) {
            inProgress.add(new FieldRule<T>(fieldRule));
        }
        ArrayList arrayList = new ArrayList();
        this.splitFieldRules(inProgress);
        double d = new GameAnalyze(null, inProgress, null).solve(arrayList);
        for (Solution solution : arrayList) {
            solution.setTotal(d);
        }
        ArrayList groups = new ArrayList();
        if (!arrayList.isEmpty()) {
            for (FieldGroup fieldGroup : ((Solution)arrayList.get(0)).getSetGroupValues().keySet()) {
                groups.add(fieldGroup);
            }
        }
        AnalyzeResultsImpl analyzeResultsImpl = new AnalyzeResultsImpl(original, inProgress, groups, arrayList, d);
        return analyzeResultsImpl;
    }

    public void splitFieldRules(List<FieldRule<T>> rules) {
        if (rules.size() <= 1) {
            return;
        }
        boolean splitPerformed = true;
        while (splitPerformed) {
            splitPerformed = false;
            for (FieldRule<T> a : rules) {
                for (FieldRule<T> b : rules) {
                    boolean result = a.checkIntersection(b);
                    if (!result) continue;
                    splitPerformed = true;
                }
            }
        }
    }

    public void splitFieldRules() {
        this.splitFieldRules(this.rules);
    }

    public void addRule(FieldRule<T> rule) {
        this.rules.add(rule);
    }

    public List<FieldGroup<T>> getGroups() {
        HashSet<FieldGroup<T>> agroups = new HashSet<FieldGroup<T>>();
        for (FieldRule<T> rule : this.rules) {
            agroups.addAll(rule.getFieldGroups());
        }
        return new ArrayList<FieldGroup<T>>(agroups);
    }

    public List<FieldRule<T>> getRules() {
        return new ArrayList<FieldRule<T>>(this.rules);
    }
}

