/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.plugin.twovstwo;

import java.util.HashMap;
import java.util.Map;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.classic.DefaultExpanderRule;
import net.zomis.minesweeper.classic.EndShowMines;
import net.zomis.minesweeper.classic.StandardNeighbors;
import net.zomis.minesweeper.classic.StandardWeapons;
import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.EventRegister;
import net.zomis.minesweeper.events.EventRegistrator;
import net.zomis.minesweeper.events.game.FieldActivatedEvent;
import net.zomis.minesweeper.events.game.GameEndedEvent;
import net.zomis.minesweeper.events.game.GameInitEvent;
import net.zomis.minesweeper.events.game.GamePreGenerateEvent;
import net.zomis.minesweeper.events.game.PlayerAfterMoveEvent;
import net.zomis.minesweeper.events.game.PlayerEliminateCheckEvent;
import net.zomis.minesweeper.functional.Consumer;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.weapons.MinesweeperWeapon;
import net.zomis.minesweeper.weapons.classic.ClickWeapon;
import net.zomis.plugin.twovstwo.Mfe2vs2Bomb;

public class TwoVsTwo
extends MinesweeperPlugin
implements EventRegistrator {
    private static final int NUM_TEAMS = 2;

    public void onGameInit(GameInitEvent event) {
        for (MinesweeperPlayingPlayer player : event.getMap().getPlayingPlayers()) {
            player.giveWeapon((MinesweeperWeapon)new ClickWeapon());
            player.giveWeapon((MinesweeperWeapon)new Mfe2vs2Bomb());
        }
    }

    public void onFieldActivated(FieldActivatedEvent event) {
        if (event.getField() == null) {
            return;
        }
        if (!event.getField().isMine()) {
            return;
        }
        MinesweeperPlayingPlayer player = event.getPlayingPlayer();
        if (player == null) {
            return;
        }
        if (player.getIndex() >= 2) {
            event.getField().activate((MinesweeperPlayingPlayer)event.getMap().getPlayingPlayers().get(player.getIndex() % 2));
            event.getField().sendInfoToPlayers();
        }
    }

    public static Map<Integer, Integer> getTeamScores(MinesweeperMap map) {
        HashMap<Integer, Integer> teamScores = new HashMap<Integer, Integer>();
        for (int i = 0; i < 2; ++i) {
            teamScores.put(i, 0);
        }
        for (MinesweeperPlayingPlayer pp : map.getPlayingPlayers()) {
            teamScores.put(TwoVsTwo.getTeam(pp), (Integer)teamScores.get(TwoVsTwo.getTeam(pp)) + pp.getScore());
        }
        return teamScores;
    }

    public static int getTeam(MinesweeperPlayingPlayer pp) {
        return pp.getIndex() % 2;
    }

    public void onElimination(PlayerEliminateCheckEvent event) {
        event.setCancelled(true);
        Map<Integer, Integer> teamScores = TwoVsTwo.getTeamScores(event.getMap());
        for (Map.Entry<Integer, Integer> ee : teamScores.entrySet()) {
            if (!((double)ee.getValue().intValue() >= (double)event.getMap().getMinesCount() / 2.0)) continue;
            for (MinesweeperPlayingPlayer pp : event.getMap().getPlayingPlayers()) {
                if (TwoVsTwo.getTeam(pp) == ee.getKey() || pp.isEliminated()) continue;
                pp.eliminateLoss();
            }
            if (event.getGame() != null) {
                event.getGame().sendChatMessage("Team " + ((MinesweeperPlayingPlayer)event.getMap().getPlayingPlayers().get(ee.getKey())).getName() + " won with a total of " + ee.getValue());
            }
            for (MinesweeperPlayingPlayer pp : event.getMap().getPlayingPlayers()) {
                if (pp.getIndex() < 2) continue;
                pp.eliminateLoss();
            }
        }
    }

    public void onDisable() {
    }

    public void onEnable() {
        this.registerListener((EventListener)new DefaultExpanderRule());
        this.registerListener((EventListener)new EndShowMines());
    }

    public boolean canBeChosenBy(MinesweeperPlayer user) {
        return true;
    }

    public void registerEvents(EventRegister events) {
        events.registerListener(GameInitEvent.class, (Consumer)new Consumer<GameInitEvent>(){

            public void accept(GameInitEvent gameInitEvent) {
                TwoVsTwo.this.onGameInit(gameInitEvent);
            }
        });
        events.registerListener(FieldActivatedEvent.class, (Consumer)new Consumer<FieldActivatedEvent>(){

            public void accept(FieldActivatedEvent fieldActivatedEvent) {
                TwoVsTwo.this.onFieldActivated(fieldActivatedEvent);
            }
        });
        events.registerListener(PlayerEliminateCheckEvent.class, (Consumer)new Consumer<PlayerEliminateCheckEvent>(){

            public void accept(PlayerEliminateCheckEvent playerEliminateCheckEvent) {
                TwoVsTwo.this.onElimination(playerEliminateCheckEvent);
            }
        });
        events.registerListener(GamePreGenerateEvent.class, StandardNeighbors.classicNeighbors);
        events.registerListener(PlayerAfterMoveEvent.class, (Consumer)new DefaultExpanderRule());
        events.registerListener(GameEndedEvent.class, (Consumer)new EndShowMines());
        events.registerListener(GameInitEvent.class, (Consumer)new StandardWeapons());
    }
}

