/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.plugin.nonstandard;

import net.zomis.minesweeper.events.EventRegister;
import net.zomis.minesweeper.events.EventRegistrator;
import net.zomis.minesweeper.events.game.GameInitEvent;
import net.zomis.minesweeper.events.game.GamePreGenerateEvent;
import net.zomis.minesweeper.functional.Consumer;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.weapons.MinesweeperWeapon;
import net.zomis.minesweeper.weapons.classic.ClickWeapon;
import net.zomis.plugin.nonstandard.SizedBombWeapon;

public class SmallerBoard
implements EventRegistrator,
Consumer<GamePreGenerateEvent> {
    private final int size;

    public SmallerBoard(int size) {
        this.size = size;
    }

    public void accept(GamePreGenerateEvent event) {
        this.fixMap(event.getMap());
    }

    private void fixMap(MinesweeperMap map) {
        for (int xx = 0; xx < map.getFieldWidth() - this.size; ++xx) {
            int xcol = xx % 2 == 0 ? xx / 2 : map.getFieldWidth() - xx / 2 - 1;
            for (int yy = 0; yy < map.getFieldHeight(); ++yy) {
                map.getPosition(xcol, yy).setBlocked(true);
            }
        }
        for (int yy = 0; yy < map.getFieldHeight() - this.size; ++yy) {
            int yrow = yy % 2 == 0 ? yy / 2 : map.getFieldHeight() - yy / 2 - 1;
            for (int xx = 0; xx < map.getFieldWidth(); ++xx) {
                map.getPosition(xx, yrow).setBlocked(true);
            }
        }
        map.sendUpdateToPlayers();
    }

    public void onStartGame(GameInitEvent event) {
        int mcount = (int)((double)(this.size * this.size) * 0.2);
        if (mcount % 2 == 0) {
            ++mcount;
        }
        event.getMap().setMinesCount(mcount);
        for (MinesweeperPlayingPlayer player : event.getMap().getPlayingPlayers()) {
            player.giveWeapon((MinesweeperWeapon)new ClickWeapon());
            player.giveWeapon((MinesweeperWeapon)new SizedBombWeapon(this.size / 3, this.size));
        }
    }

    public void registerEvents(EventRegister events) {
        events.registerListener(GamePreGenerateEvent.class, (Consumer)this);
        events.registerListener(GameInitEvent.class, (Consumer)new Consumer<GameInitEvent>(){

            public void accept(GameInitEvent gameInitEvent) {
                SmallerBoard.this.onStartGame(gameInitEvent);
            }
        });
    }
}

