/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.plugin.nonstandard;

import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.classic.DefaultExpanderRule;
import net.zomis.minesweeper.classic.EndShowMines;
import net.zomis.minesweeper.classic.StandardWeapons;
import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.EventRegister;
import net.zomis.minesweeper.events.EventRegistrator;
import net.zomis.minesweeper.events.game.GameEndedEvent;
import net.zomis.minesweeper.events.game.GameInitEvent;
import net.zomis.minesweeper.events.game.GamePreGenerateEvent;
import net.zomis.minesweeper.events.game.PlayerAfterMoveEvent;
import net.zomis.minesweeper.functional.Consumer;
import net.zomis.minesweeper.game.MinesweeperField;

public class SingleStepNeighbors
extends MinesweeperPlugin
implements Consumer<GamePreGenerateEvent>,
EventRegistrator {
    public void accept(GamePreGenerateEvent event) {
        for (MinesweeperField mf : event.getMap().getIteration()) {
            mf.addNeighbor(-1, 0);
            mf.addNeighbor(1, 0);
            mf.addNeighbor(0, -1);
            mf.addNeighbor(0, 1);
        }
    }

    public void onDisable() {
    }

    public void onEnable() {
        this.registerListener((EventListener)new DefaultExpanderRule());
        this.registerListener((EventListener)new EndShowMines());
        this.registerListener((EventListener)new StandardWeapons());
    }

    public boolean canBeChosenBy(MinesweeperPlayer player) {
        return true;
    }

    public void registerEvents(EventRegister events) {
        events.registerListener(PlayerAfterMoveEvent.class, (Consumer)new DefaultExpanderRule());
        events.registerListener(GameEndedEvent.class, (Consumer)new EndShowMines());
        events.registerListener(GameInitEvent.class, (Consumer)new StandardWeapons());
        events.registerListener(GamePreGenerateEvent.class, (Consumer)this);
    }
}

