/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.plugin.floodfill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.weapons.BaseWeapon;
import net.zomis.minesweeper.weapons.LimitedUseWeapon;

public class FloodFillWeapon
extends LimitedUseWeapon {
    public FloodFillWeapon(int useCount) {
        super(useCount);
    }

    public String getWeaponType() {
        return "P";
    }

    public boolean canUseAt(MinesweeperPlayingPlayer user, MinesweeperField field) {
        return !field.isClicked();
    }

    public Collection<MinesweeperField> getFieldsAffected(MinesweeperPlayingPlayer user, MinesweeperField field) {
        ArrayList<MinesweeperField> result = new ArrayList<MinesweeperField>();
        result.add(field);
        this.recursiveAdd(result, field, new BaseWeapon.RecursiveInterface(){

            public boolean performAdd(MinesweeperField from, MinesweeperField to) {
                return this.performRecursive(from, to);
            }

            public Collection<MinesweeperField> getRecursiveFields(MinesweeperField field) {
                HashSet<MinesweeperField> fields = new HashSet<MinesweeperField>();
                fields.add(field.getRelativePosition(-1, 0));
                fields.add(field.getRelativePosition(0, -1));
                fields.add(field.getRelativePosition(1, 0));
                fields.add(field.getRelativePosition(0, 1));
                return fields;
            }

            public boolean performRecursive(MinesweeperField from, MinesweeperField to) {
                if (from.isMine()) {
                    return to.getMineValue() == from.getMineValue();
                }
                return !to.isMine() && to.getValue() == from.getValue();
            }
        });
        return result;
    }

    protected boolean performUse(MinesweeperMove moveInfo) {
        if (!this.canUseAt(moveInfo.getPlayer(), moveInfo.getMovePosition())) {
            return false;
        }
        for (MinesweeperField mf : this.getFieldsAffected(moveInfo.getPlayer(), moveInfo.getMovePosition())) {
            mf.activate(moveInfo);
        }
        moveInfo.getMap().nextTurn();
        return true;
    }

    public boolean allowedUse(MinesweeperPlayingPlayer user) {
        return true;
    }
}

