/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.plugin.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.zomis.minesweeper.api.FieldInfo;
import net.zomis.minesweeper.api.FieldType;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.weapons.BaseWeapon;

public class EditorWeapon
extends BaseWeapon {
    private static final int POS_MINE = 9;
    private static final int POS_BLOCKED = 10;
    private static final int POS_UNCLICKED = 11;
    private FieldType selectedFieldType;
    private int selectedValue;
    private boolean selectedIsMine;
    private List<MinesweeperField> editorFields = new ArrayList<MinesweeperField>();
    private final MinesweeperPlayingPlayer player;
    private int editorRow;

    public EditorWeapon(MinesweeperPlayingPlayer player) {
        this.player = player;
        this.setEditorFields(0);
    }

    public void setEditorFields(int row) {
        MinesweeperField ff;
        int i;
        this.editorRow = row;
        for (MinesweeperField field : this.editorFields) {
            field.sendInfoToPlayer(this.player);
            if (!this.player.getPlayer().isClientFlash()) continue;
            field.sendInfoToPlayer(this.player);
        }
        this.editorFields.clear();
        for (i = 0; i < this.player.getMap().getFieldWidth(); ++i) {
            ff = this.player.getMap().getPosition(i, row);
            if (i <= 8) {
                this.player.getPlayer().sendFieldInfo(ff, new FieldInfo(i));
            } else {
                if (i == 9) {
                    this.player.getPlayer().sendFieldInfo(ff, FieldInfo.VISIBLE_MINE);
                }
                if (i == 10) {
                    this.player.getPlayer().sendFieldInfo(ff, FieldInfo.BLOCKED);
                }
                if (i == 11) {
                    this.player.getPlayer().sendFieldInfo(ff, FieldInfo.UNCLICKED);
                }
            }
            this.editorFields.add(ff);
        }
        row = row < this.player.getMap().getFieldHeight() / 2 ? ++row : --row;
        for (i = 0; i < this.player.getMap().getFieldWidth(); ++i) {
            ff = this.player.getMap().getPosition(i, row);
            this.player.getPlayer().sendFieldInfo(ff, FieldInfo.BLOCKED);
            this.editorFields.add(ff);
        }
    }

    public int getUsesRemaining() {
        return -1;
    }

    public String getWeaponType() {
        return "P";
    }

    public boolean canUse(MinesweeperPlayingPlayer user) {
        return true;
    }

    public boolean canUseAt(MinesweeperPlayingPlayer user, MinesweeperField field) {
        return true;
    }

    public Collection<MinesweeperField> getFieldsAffected(MinesweeperPlayingPlayer user, MinesweeperField field) {
        ArrayList<MinesweeperField> result = new ArrayList<MinesweeperField>();
        result.add(field);
        return result;
    }

    public boolean useAt(MinesweeperMove moveInfo) {
        if (!this.canUseAt(moveInfo.getPlayer(), moveInfo.getMovePosition())) {
            return false;
        }
        if (this.editorFields.contains(moveInfo.getMovePosition()) || this.editorRow == moveInfo.getMovePosition().getY()) {
            if (moveInfo.getMovePosition().getY() != this.editorRow) {
                this.setEditorFields(this.player.getMap().getFieldHeight() - this.editorRow - 1);
            }
            this.selectedValue = moveInfo.getMovePosition().getX();
            if (this.selectedValue > 8) {
                this.selectedValue = -1;
            }
            boolean bl = this.selectedIsMine = moveInfo.getMovePosition().getX() == 9;
            this.selectedFieldType = moveInfo.getMovePosition().getX() == 10 ? FieldType.BLOCKED : (moveInfo.getMovePosition().getX() == 11 ? FieldType.UNCLICKED : FieldType.CLICKED);
            this.player.getPlayer().sendChat("Changed selection: " + String.format("%d %s %d", this.selectedValue, this.selectedIsMine + "", this.selectedFieldType));
            return true;
        }
        for (MinesweeperField field : this.getFieldsAffected(moveInfo.getPlayer(), moveInfo.getMovePosition())) {
            field.setBlocked(this.selectedFieldType == FieldType.BLOCKED);
            if (this.selectedFieldType == FieldType.UNCLICKED) {
                field.inactivate();
            } else {
                field.setMine(this.selectedIsMine);
            }
            if (this.selectedValue >= 0) {
                field.setValue(this.selectedValue);
                field.activate();
            }
            if (this.selectedFieldType != FieldType.UNCLICKED) {
                field.activate(moveInfo);
            }
            field.sendInfoToPlayers();
        }
        return true;
    }

    public void resetUsage() {
        this.setEditorFields(0);
    }
}

