/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.commands;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

public class GameResults1v1 {
    private Map<String, PlayerResults> scores = new HashMap<String, PlayerResults>();
    private final boolean separateIndex;

    public GameResults1v1(boolean separateIndex) {
        this.separateIndex = separateIndex;
    }

    public Map<String, PlayerResults> getResults() {
        return new HashMap<String, PlayerResults>(this.scores);
    }

    public void saveResult(List<MinesweeperPlayingPlayer> pplayers) {
        if (pplayers.size() != 2) {
            throw new UnsupportedOperationException("Method only works for 2 players");
        }
        for (MinesweeperPlayingPlayer pp1 : pplayers) {
            if (!this.scores.containsKey(this.key(pp1))) {
                this.scores.put(this.key(pp1), new PlayerResults());
            }
            PlayerResults result = this.scores.get(this.key(pp1));
            for (MinesweeperPlayingPlayer pp2 : pplayers) {
                if (pp1 == pp2) continue;
                result.addResult(pp2);
            }
        }
    }

    private String key(MinesweeperPlayingPlayer pp) {
        return this.separateIndex ? pp.getName() + "@" + pp.getIndex() : pp.getName();
    }

    public class PlayerResults {
        private Map<String, Integer> wins = new HashMap<String, Integer>();
        private Map<String, Integer> totalGames = new HashMap<String, Integer>();

        private PlayerResults() {
        }

        public void addResult(MinesweeperPlayingPlayer opponent) {
            this.mapChange(this.wins, opponent, opponent.getResultPosition() == 1 ? 0 : 1);
            this.mapChange(this.totalGames, opponent, 1);
        }

        public int getWins(String key) {
            return this.wins.get(key) == null ? 0 : this.wins.get(key);
        }

        public int getTotal(String key) {
            return this.totalGames.get(key) == null ? 0 : this.totalGames.get(key);
        }

        public double getPercent(String key) {
            return (double)this.getWins(key) / (double)this.getTotal(key);
        }

        public Set<String> getKeys() {
            return this.wins.keySet();
        }

        private void mapChange(Map<String, Integer> map, MinesweeperPlayingPlayer opponent, int change) {
            Integer oldValue = map.get(GameResults1v1.this.key(opponent));
            if (oldValue == null) {
                oldValue = 0;
            }
            map.put(GameResults1v1.this.key(opponent), oldValue + change);
        }
    }
}

