/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.plugin.editor;

import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.events.Command;
import net.zomis.minesweeper.events.EventRegister;
import net.zomis.minesweeper.events.EventRegistrator;
import net.zomis.minesweeper.events.game.GameInitEvent;
import net.zomis.minesweeper.events.invites.InvitePreStartEvent;
import net.zomis.minesweeper.events.player.PlayerCommandEvent;
import net.zomis.minesweeper.functional.Consumer;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.weapons.MinesweeperWeapon;
import net.zomis.plugin.editor.EditorWeapon;

public class Editor
extends MinesweeperPlugin
implements EventRegistrator {
    public void onInviteGameStart(InvitePreStartEvent event) {
        if (event.getInvite().getPlugins().contains((Object)this)) {
            event.getInvite().setDatabase(false);
        }
    }

    @Command(command="editor", help="")
    public void command(PlayerCommandEvent event) {
        if (event.getPlayer().getGame() == null) {
            return;
        }
        if (!event.getPlayer().getGame().hasPlugin((MinesweeperPlugin)this)) {
            return;
        }
    }

    public void onGameStart(GameInitEvent event) {
        event.getGame().sendChatMessage("This is an editor. Any player can modify the map at any time.");
        event.getGame().setActionMode(true);
        for (MinesweeperPlayingPlayer player : event.getMap().getPlayingPlayers()) {
            player.giveWeapon((MinesweeperWeapon)new EditorWeapon(player));
        }
    }

    public void onDisable() {
    }

    public void onEnable() {
    }

    public boolean canBeChosenBy(MinesweeperPlayer user) {
        return user.hasPermission("TESTER");
    }

    public void registerEvents(EventRegister events) {
        events.registerListener(InvitePreStartEvent.class, (Consumer)new Consumer<InvitePreStartEvent>(){

            public void accept(InvitePreStartEvent invitePreStartEvent) {
                Editor.this.onInviteGameStart(invitePreStartEvent);
            }
        });
        events.registerListener(GameInitEvent.class, (Consumer)new Consumer<GameInitEvent>(){

            public void accept(GameInitEvent gameInitEvent) {
                Editor.this.onGameStart(gameInitEvent);
            }
        });
    }
}

