/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.plugin.nonstandard;

import java.util.ArrayList;
import java.util.Collection;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.weapons.BaseWeapon;

public class SniperWeapon
extends BaseWeapon {
    public String getWeaponType() {
        return "S";
    }

    public boolean canUse(MinesweeperPlayingPlayer user) {
        return true;
    }

    public boolean canUseAt(MinesweeperPlayingPlayer user, MinesweeperField field) {
        Collection<MinesweeperField> affected = this.getFieldsAffected(user, field);
        if (affected == null) {
            return false;
        }
        return affected.size() > 0;
    }

    public Collection<MinesweeperField> getFieldsAffected(MinesweeperPlayingPlayer user, MinesweeperField field) {
        ArrayList<MinesweeperField> result = new ArrayList<MinesweeperField>();
        if (!field.isClicked()) {
            result.add(field);
        }
        return result;
    }

    public boolean useAt(MinesweeperMove moveInfo) {
        if (!this.canUseAt(moveInfo.getPlayer(), moveInfo.getMovePosition())) {
            return false;
        }
        moveInfo.getMovePosition().activate(moveInfo);
        moveInfo.getMap().nextTurn();
        return true;
    }

    public void resetUsage() {
    }
}

