/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.plugin.mtmt;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.zomis.minesweeper.api.Invite;
import net.zomis.minesweeper.api.Minesweeper;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperServer;
import net.zomis.minesweeper.events.invites.InviteGameStartingEvent;
import net.zomis.minesweeper.game.GameTag;
import net.zomis.minesweeper.game.MinesweeperGame;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.plugin.mtmt.MataMata;

public class Jogo {
    private static final Integer WAIT_FOR_NOBODY = Integer.MIN_VALUE;
    private static final Integer RESULT_WALKOVER = -2147483647;
    private static final String GAMETAG = "mata-mata";
    private static final String TOURNAMENT_TAG = "tournament-game";
    private final int[] waitingFor = new int[]{WAIT_FOR_NOBODY, WAIT_FOR_NOBODY};
    private final Map<MinesweeperPlayer, Integer> playersAndResults = new HashMap<MinesweeperPlayer, Integer>();
    private MinesweeperGame game = null;
    private final MataMata mtmt;
    private boolean alerted = false;

    public Jogo(MataMata mtmt, MinesweeperPlayer player1, MinesweeperPlayer player2) {
        this.mtmt = mtmt;
        this.playersAndResults.put(player1, null);
        this.playersAndResults.put(player2, null);
    }

    public Jogo(MataMata mtmt, MinesweeperPlayer player1, int player2) {
        this.mtmt = mtmt;
        this.playersAndResults.put(player1, null);
        this.waitingFor[0] = player2;
    }

    public Jogo(MataMata mtmt, int player1, int player2) {
        this.mtmt = mtmt;
        this.waitingFor[0] = player1;
        this.waitingFor[1] = player2;
    }

    public synchronized boolean informGameEnd(MinesweeperGame game) {
        if (game != this.game) {
            return false;
        }
        this.playersAndResults.clear();
        for (MinesweeperPlayingPlayer pp : game.getPlayingPlayers()) {
            this.playersAndResults.put(pp.getPlayer(), pp.getScore());
        }
        this.getServer().log("Zomis", "Jogo Informed " + this + " about game end: " + game);
        this.mtmt.informJogoEnd(this);
        return true;
    }

    public boolean matches(InviteGameStartingEvent event) {
        if (this.hasWaitingFor()) {
            return false;
        }
        if (this.game != null) {
            return false;
        }
        List gamePlayers = event.getGame().getPlayers();
        HashSet<MinesweeperPlayer> a = new HashSet<MinesweeperPlayer>(this.playersAndResults.keySet());
        if (gamePlayers.size() != a.size()) {
            return false;
        }
        for (MinesweeperPlayer pl : a) {
            if (gamePlayers.contains(pl)) continue;
            return false;
        }
        this.game = event.getGame();
        this.game.sendChatMessage("This is a game in " + this.mtmt, Integer.valueOf(0xFF00FF));
        this.tagGame();
        return true;
    }

    private void tagGame() {
        this.game.addTag(this.mtmt.hasId() ? new GameTag(GameTag.TagType.SERVER, this.game, GAMETAG, this.mtmt.getId()) : null);
        this.game.addTag(new GameTag(GameTag.TagType.SERVER, this.game, TOURNAMENT_TAG, Integer.valueOf(this.mtmt.getJogoIndex(this))));
    }

    private boolean hasWaitingFor() {
        for (int i : this.waitingFor) {
            if (i <= WAIT_FOR_NOBODY) continue;
            return true;
        }
        return false;
    }

    public void sendInfo(MinesweeperPlayer player) {
        player.sendChatBy(this.toString(player, true), this.getServer().getServerPlayer());
    }

    public String toString(MinesweeperPlayer highlight, boolean useDisplayName) {
        String str = "";
        for (Map.Entry<MinesweeperPlayer, Integer> entry : this.playersAndResults.entrySet()) {
            Minesweeper.getServer().log("Mtmt", "toString loop " + this.mtmt.getJogoIndex(this) + ": " + entry.getKey() + ": " + entry.getValue());
            if (!str.isEmpty()) {
                str = str + " vs. ";
            }
            if (entry.getKey().equals(highlight)) {
                str = str + String.format("<font color=\"#ffff00\">", new Object[0]);
            }
            str = str + (useDisplayName ? entry.getKey().getDisplayName() : entry.getKey().getName());
            if (entry.getValue() != null) {
                str = str + " (" + (entry.getValue() == RESULT_WALKOVER ? "WO" : (Serializable)entry.getValue()) + ")";
            }
            if (!entry.getKey().equals(highlight)) continue;
            str = str + "</font>";
        }
        for (Object i : (Object)this.waitingFor) {
            if (i == WAIT_FOR_NOBODY.intValue()) continue;
            if (!str.isEmpty()) {
                str = str + " vs. ";
            }
            Jogo jogo = this.mtmt.getJogo(Math.abs((int)i));
            str = str + "(" + (i >= 0 ? "Winner" : "Loser") + " of " + jogo.getGameDescription() + ")";
        }
        return this.getGameDescription() + ": " + str;
    }

    public String toString() {
        return this.toString(null, true);
    }

    private String getGameDescription() {
        return "Game" + (this.game != null ? "id " + this.game.getGameID() : " " + this.mtmt.getJogoIndex(this));
    }

    public boolean autoAIcheck() {
        if (this.game != null) {
            return false;
        }
        for (int i : this.waitingFor) {
            if (i == WAIT_FOR_NOBODY) continue;
            return false;
        }
        Object object = this.playersAndResults.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry ee = (Map.Entry)object.next();
            if (!((MinesweeperPlayer)ee.getKey()).isAI()) {
                return false;
            }
            if (ee.getValue() == null) continue;
            return false;
        }
        Invite invt = null;
        for (Map.Entry<MinesweeperPlayer, Integer> ee : this.playersAndResults.entrySet()) {
            if (invt == null) {
                invt = ee.getKey().createInvitation(this.mtmt.getPlugins());
                continue;
            }
            invt.sendInvite(ee.getKey());
        }
        if (invt == null) {
            return false;
        }
        MinesweeperGame g = invt.startGame();
        if (g != null) {
            g.setAIDelay(2000);
        }
        return g != null;
    }

    private MinesweeperServer getServer() {
        return this.mtmt.getServer();
    }

    public boolean informJogoEnd(Jogo jogo, int index) {
        boolean changed = false;
        for (int i = 0; i < this.waitingFor.length; ++i) {
            int value = this.waitingFor[i];
            if (Math.abs(value) != index) continue;
            this.getServer().log("Zomis", "Jogo inform jogo end " + this + " about : " + jogo + " index " + index + " and value " + value);
            for (MinesweeperPlayer player : jogo.getPlayers()) {
                this.getServer().log("Zomis", "Jogo isWinner " + jogo.isWinner(player) + " isLoser " + jogo.isLoser(player) + " and value " + value);
                if (jogo.isWinner(player) && value >= 0) {
                    this.playersAndResults.put(player, null);
                    this.waitingFor[i] = WAIT_FOR_NOBODY;
                    continue;
                }
                if (!jogo.isLoser(player) || value >= 0) continue;
                this.playersAndResults.put(player, null);
                this.waitingFor[i] = WAIT_FOR_NOBODY;
            }
            if (this.waitingFor[i] != WAIT_FOR_NOBODY) {
                for (int j = 0; j < jogo.waitingFor.length; ++j) {
                    if (jogo.waitingFor[j] == WAIT_FOR_NOBODY) continue;
                    this.getServer().log("Zomis", "waitingFor i " + i + " is " + this.waitingFor[i] + " will be set to " + jogo.waitingFor[j]);
                    this.waitingFor[i] = jogo.waitingFor[j];
                }
            }
            changed = true;
        }
        if (changed && !this.hasWaitingFor()) {
            this.alertPlayers();
        }
        return changed;
    }

    private boolean isLoser(MinesweeperPlayer player) {
        if (this.game != null) {
            if (!this.game.isGameOver()) {
                throw new IllegalStateException("Game is not over: " + this.game + " for jogo " + this);
            }
            MinesweeperPlayingPlayer pp = this.game.getPlayingPlayer(player);
            return pp.isEliminated() && pp.getResultPosition() > this.game.getPlayingPlayers().size() / 2;
        }
        return this.playersAndResults.get(player) == RESULT_WALKOVER;
    }

    private Set<MinesweeperPlayer> getPlayers() {
        if (this.game != null) {
            HashSet<MinesweeperPlayer> set = new HashSet<MinesweeperPlayer>();
            for (MinesweeperPlayingPlayer pp : this.game.getPlayingPlayers()) {
                set.add(pp.getPlayer());
            }
            return set;
        }
        return this.playersAndResults.keySet();
    }

    private boolean isWinner(MinesweeperPlayer player) {
        if (this.game != null) {
            if (!this.game.isGameOver()) {
                throw new IllegalStateException("Game is not over: " + this.game + " for jogo " + this);
            }
            MinesweeperPlayingPlayer pp = this.game.getPlayingPlayer(player);
            return pp.isEliminated() && pp.getResultPosition() <= this.game.getPlayingPlayers().size() / 2;
        }
        if (this.isWalkover()) {
            return this.playersAndResults.get(player) != RESULT_WALKOVER;
        }
        throw new IllegalStateException("Jogo is not null and is not walkover: " + this);
    }

    private boolean isWalkover() {
        for (Integer value : this.playersAndResults.values()) {
            if (value == null || value != RESULT_WALKOVER) continue;
            return true;
        }
        return false;
    }

    public MinesweeperGame getGame() {
        return this.game;
    }

    public boolean isFinished() {
        return this.getGame() != null && this.getGame().isGameOver();
    }

    public void alertPlayers() {
        if (this.alerted) {
            return;
        }
        if (this.hasWaitingFor()) {
            return;
        }
        if (this.game != null) {
            return;
        }
        for (MinesweeperPlayer p : this.playersAndResults.keySet()) {
            p.sendAlert("Mata-Mata:\n" + this.toString(null, false));
        }
        this.alerted = true;
    }

    public void informWalkover(MinesweeperPlayer player) {
        if (!this.playersAndResults.containsKey(player)) {
            return;
        }
        if (this.game == null) {
            this.playersAndResults.put(player, RESULT_WALKOVER);
            this.mtmt.informJogoEnd(this);
        } else {
            if (this.game.getPlayingPlayer(player).isEliminated()) {
                return;
            }
            this.game.getPlayingPlayer(player).eliminateLoss();
            this.mtmt.walkover(player);
        }
    }
}

