/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.commands;

import net.zomis.minesweeper.api.FieldInfo;
import net.zomis.minesweeper.api.FieldType;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.events.Command;
import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.player.PlayerCommandEvent;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperGame;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

public class CheatCommands
extends MinesweeperPlugin
implements EventListener {
    private FieldInfo cheatMine = new FieldInfo().setMine(true).setFieldType(FieldType.CLICKED).setHighlight(false).setValue(0);

    private char charForField(MinesweeperField field) {
        if (field.isMine()) {
            return "*".charAt(0);
        }
        return String.valueOf(field.getValue()).charAt(0);
    }

    @Command(command="mygel", help="Super-\u00fcber-mega-ultra-cheat", requiredPermission="ADMIN")
    public void onMygelCommand(PlayerCommandEvent event) {
        MinesweeperGame game = event.getPlayer().getGame();
        if (game.isStoredInDatabase()) {
            event.getPlayer().sendChat("Cheats are not allowed in database-stored games.");
            return;
        }
        MinesweeperPlayer play = event.getPlayer();
        for (MinesweeperPlayingPlayer player : game.getPlayingPlayers()) {
            play.sendChat("Player " + player.getIndex() + ": " + player.getName() + " (" + player.getScore() + ")");
        }
        for (int y = 0; y < game.getFieldHeight(); ++y) {
            String line = "";
            for (int x = 0; x < game.getFieldWidth(); ++x) {
                MinesweeperField mf = game.getPosition(x, y);
                line = line + this.charForField(mf);
                if (!mf.isMine() || mf.isClicked()) continue;
                play.sendFieldInfo(mf, this.cheatMine);
            }
            play.sendChat(line);
        }
        play.sendChat("Mines left: " + game.getMinesLeft());
    }

    @Command(command="aistuck", help="AI Stuck? Use this!")
    public void onAIPlay(PlayerCommandEvent event) {
        MinesweeperGame game = event.getPlayer().getGame();
        if (game != null) {
            game.callAI();
        }
    }

    public void onDisable() {
    }

    public boolean canBeChosenBy(MinesweeperPlayer arg0) {
        return false;
    }

    public void onEnable() {
        this.registerListener(this);
    }
}

