/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.plugin.mtmt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.zomis.UtilZomisUtils;
import net.zomis.minesweeper.api.Minesweeper;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperServer;
import net.zomis.minesweeper.api.ServerSelectResult;
import net.zomis.minesweeper.events.invites.InviteGameStartingEvent;
import net.zomis.minesweeper.game.MinesweeperGame;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.plugin.mtmt.Jogo;

public class MataMata {
    private static final boolean useDB = false;
    private Integer id = null;
    private final List<MinesweeperPlayer> players = new ArrayList<MinesweeperPlayer>();
    private List<Jogo> jogos = new ArrayList<Jogo>();
    private final MinesweeperPlayer creator;
    private boolean started = false;
    private boolean ended;
    private boolean matchForThirdPrize = false;

    public Integer getId() {
        return this.id;
    }

    public boolean hasId() {
        return this.id != null;
    }

    public MataMata(MinesweeperPlayer creator) {
        if (creator == null) {
            throw new IllegalArgumentException("Creator is null");
        }
        this.creator = creator;
        this.players.add(creator);
        creator.getServer().getGameTagParameters("mata-mata", (ServerSelectResult)new MataMataIdSet(this));
    }

    public synchronized void cancel() {
        this.getServer().broadcastChat(this + " has been stopped by the creator!");
        this.endTournament();
    }

    public synchronized boolean playerJoin(MinesweeperPlayer user) {
        if (this.players.contains(user)) {
            return false;
        }
        this.players.add(user);
        return true;
    }

    public synchronized void start() {
        int i;
        this.started = true;
        int n = this.players.size();
        Collections.shuffle(this.players);
        int f = (int)Math.ceil(Math.log(n) / Math.log(2.0));
        int oddgames = (int)((double)n - Math.pow(2.0, f - 1));
        for (int i2 = 0; i2 < oddgames; ++i2) {
            MinesweeperPlayer player1 = this.players.remove(this.players.size() - 1);
            MinesweeperPlayer player2 = this.players.remove(0);
            this.jogos.add(new Jogo(this, player1, player2));
        }
        int pow2f = (int)Math.pow(2.0, f);
        int pow2fm = (int)Math.pow(2.0, f - 1);
        int total = (int)Math.pow(2.0, f - 2);
        int m = Math.max(0, total + pow2fm - n);
        int k = Math.min(Math.abs(n - pow2f), Math.abs(n - pow2fm));
        int p = total - m - k;
        int cjogo = 0;
        for (i = 0; i < m; ++i) {
            this.jogos.add(new Jogo(this, this.players.remove(0), this.players.remove(0)));
        }
        for (i = 0; i < k; ++i) {
            this.jogos.add(new Jogo(this, this.players.remove(0), cjogo++));
        }
        for (i = 0; i < p; ++i) {
            this.jogos.add(new Jogo(this, cjogo++, cjogo++));
        }
        for (int currf = f - 3; currf >= 0; --currf) {
            int i3 = 0;
            while ((double)i3 < Math.pow(2.0, currf)) {
                this.jogos.add(new Jogo(this, cjogo++, cjogo++));
                ++i3;
            }
        }
        this.getServer().log("Players left in array: " + UtilZomisUtils.implode((String)",", this.players));
        if (this.matchForThirdPrize) {
            this.jogos.add(new Jogo(this, -(this.jogos.size() - 3), -(this.jogos.size() - 2)));
            Collections.swap(this.jogos, this.jogos.size() - 1, this.jogos.size() - 2);
        }
        if (this.jogos.isEmpty()) {
            throw new IllegalStateException("MataMata Jogos is empty: " + this);
        }
        this.jogos = Collections.unmodifiableList(this.jogos);
        this.broadcastInfo();
        this.autoAIcheck();
        this.alertPlayers();
    }

    private synchronized void alertPlayers() {
        for (Jogo jogo : this.jogos) {
            jogo.alertPlayers();
        }
    }

    private synchronized void broadcastInfo() {
        for (MinesweeperPlayer player : this.getServer().getOnlinePlayers()) {
            this.sendInfo(player);
        }
    }

    public MinesweeperServer getServer() {
        return Minesweeper.getServer();
    }

    public synchronized boolean isOpenForInvites() {
        return !this.started;
    }

    public synchronized MinesweeperPlayer getCreator() {
        return this.creator;
    }

    public synchronized void informGameEnd(MinesweeperGame game) {
        if (this.isEnded()) {
            return;
        }
        boolean isMtmt = false;
        for (Jogo jogo : this.jogos) {
            if (!jogo.informGameEnd(game)) continue;
            isMtmt = true;
        }
        if (!isMtmt) {
            return;
        }
        if (this.getUnfinishedGames().isEmpty()) {
            this.endTournament();
        }
        this.autoAIcheck();
    }

    private synchronized void endTournament() {
        this.ended = true;
        this.broadcastInfo();
        if (this.jogos != null && !this.jogos.isEmpty() && this.jogos.get(this.jogos.size() - 1).getGame() != null) {
            for (MinesweeperPlayingPlayer player : this.jogos.get(this.jogos.size() - 1).getGame().getPlayingPlayers()) {
                if (player.isEliminated()) continue;
                this.getServer().getServerPlayer().performCommand("/donut " + player.getPlayer().getDisplayName() + " for winning " + this);
            }
        }
    }

    private synchronized List<Jogo> getUnfinishedGames() {
        ArrayList<Jogo> result = new ArrayList<Jogo>();
        for (Jogo jogo : this.jogos) {
            if (jogo.isFinished()) continue;
            result.add(jogo);
        }
        return result;
    }

    public synchronized void sendInfo(MinesweeperPlayer player) {
        player.sendChatBy("Mata-Mata. Jogos = " + this.jogos.size() + " creator = " + this.getCreator(), player.getServer().getServerPlayer(), Integer.valueOf(0xFFFF00));
        if (this.isOpenForInvites()) {
            for (MinesweeperPlayer p : this.players) {
                player.sendChat("Player is signed up: " + p.getDisplayName());
            }
        } else {
            int dec3rd = this.matchForThirdPrize ? 0 : 1;
            for (int key = 0; key < this.jogos.size(); ++key) {
                int cnt = this.jogos.size();
                if (key == cnt - 64 + dec3rd) {
                    player.sendChatBy("64th-finals:", player.getServer().getServerPlayer());
                } else if (key == cnt - 32 + dec3rd) {
                    player.sendChatBy("32nd-finals:", player.getServer().getServerPlayer());
                } else if (key == cnt - 16 + dec3rd) {
                    player.sendChatBy("16th-finals:", player.getServer().getServerPlayer());
                } else if (key == cnt - 8 + dec3rd) {
                    player.sendChatBy("Quarterfinals:", player.getServer().getServerPlayer());
                } else if (key == cnt - 4 + dec3rd) {
                    player.sendChatBy("Semifinals:", player.getServer().getServerPlayer());
                } else if (key == cnt - 2 + dec3rd && this.matchForThirdPrize) {
                    player.sendChatBy("Match for 3rd prize:", player.getServer().getServerPlayer());
                } else if (key == cnt - 1) {
                    player.sendChatBy("Final:", player.getServer().getServerPlayer());
                }
                Jogo jogo = this.jogos.get(key);
                jogo.sendInfo(player);
            }
        }
    }

    public synchronized int getJogoIndex(Jogo jogo) {
        return this.jogos.indexOf(jogo);
    }

    private synchronized void autoAIcheck() {
        for (Jogo jogo : this.jogos) {
            jogo.autoAIcheck();
        }
    }

    public String[] getPlugins() {
        return null;
    }

    public synchronized void informGameStart(InviteGameStartingEvent event) {
        for (Jogo jogo : this.jogos) {
            jogo.matches(event);
        }
    }

    public synchronized void informJogoEnd(Jogo jogo) {
        for (Jogo j : this.jogos) {
            j.informJogoEnd(jogo, this.getJogoIndex(jogo));
        }
    }

    public synchronized Jogo getJogo(int jogoIndex) {
        return this.jogos.get(jogoIndex);
    }

    public synchronized boolean isEnded() {
        return this.ended;
    }

    public synchronized void walkover(MinesweeperPlayer player) {
        if (this.isOpenForInvites()) {
            this.players.remove(player);
        } else {
            for (Jogo jogo : this.jogos) {
                jogo.informWalkover(player);
            }
        }
    }

    public String toString() {
        return this.id == null ? super.toString() : "MataMata #" + this.id;
    }

    private static class MataMataIdSet
    implements ServerSelectResult<Integer> {
        private MataMata mtmt;

        public MataMataIdSet(MataMata mtmt) {
            this.mtmt = mtmt;
        }

        public void onResult(List<Integer> result) {
            Integer last = null;
            if (!result.isEmpty()) {
                last = result.get(result.size() - 1);
            }
            if (last == null) {
                last = 0;
            }
            this.mtmt.id = last + 1;
            this.mtmt.getServer().broadcastLobbyChat(this.mtmt + " got id " + this.mtmt.id);
            this.mtmt = null;
        }

        public void onError(Exception e) {
            this.mtmt.getServer().broadcastLobbyChat("Could not set id for " + this.mtmt + ": " + e.getMessage());
        }
    }
}

