/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.plugin.floodfill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.weapons.BaseWeapon;

public class FloodFillWeapon
extends BaseWeapon {
    private static final int numberOfUses = 3;
    private int hasUsed = 0;

    public String getWeaponType() {
        return "P";
    }

    public boolean canUseAt(MinesweeperPlayingPlayer user, MinesweeperField field) {
        return !field.isClicked();
    }

    public Collection<MinesweeperField> getFieldsAffected(MinesweeperPlayingPlayer user, MinesweeperField field) {
        ArrayList<MinesweeperField> result = new ArrayList<MinesweeperField>();
        result.add(field);
        this.recursiveAdd(result, field, new BaseWeapon.RecursiveInterface(){

            public boolean performAdd(MinesweeperField from, MinesweeperField to) {
                return this.performRecursive(from, to);
            }

            public Collection<MinesweeperField> getRecursiveFields(MinesweeperField field) {
                HashSet<MinesweeperField> fields = new HashSet<MinesweeperField>();
                fields.add(field.getRelativePosition(-1, 0));
                fields.add(field.getRelativePosition(0, -1));
                fields.add(field.getRelativePosition(1, 0));
                fields.add(field.getRelativePosition(0, 1));
                return fields;
            }

            public boolean performRecursive(MinesweeperField from, MinesweeperField to) {
                if (from.isMine()) {
                    return to.getMineValue() == from.getMineValue();
                }
                return !to.isMine() && to.getValue() == from.getValue();
            }
        });
        return result;
    }

    public boolean useAt(MinesweeperMove moveInfo) {
        if (!this.canUseAt(moveInfo.getPlayer(), moveInfo.getMovePosition())) {
            return false;
        }
        for (MinesweeperField mf : this.getFieldsAffected(moveInfo.getPlayer(), moveInfo.getMovePosition())) {
            mf.activate(moveInfo);
        }
        moveInfo.getMap().nextTurn();
        return true;
    }

    public boolean canUse(MinesweeperPlayingPlayer user) {
        return this.hasUsed < 3;
    }

    public void resetUsage() {
        this.hasUsed = 0;
    }
}

